/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.OnlyBranchCoverageSuiteFitness;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.line.LineCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.mutation.OnlyMutationSuiteFitness;
import org.evosuite.coverage.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.rho.RhoCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.statistics.ChromosomeOutputVariableFactory;
import org.evosuite.statistics.DirectSequenceOutputVariableFactory;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.PropertyOutputVariableFactory;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.SequenceOutputVariableFactory;
import org.evosuite.statistics.backend.CSVStatisticsBackend;
import org.evosuite.statistics.backend.ConsoleStatisticsBackend;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.evosuite.statistics.backend.HTMLStatisticsBackend;
import org.evosuite.statistics.backend.StatisticsBackend;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Listener;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchStatistics
implements Listener<ClientStateInformation> {
    private static final long serialVersionUID = -1859683466333302151L;
    private static SearchStatistics instance = null;
    private static final Logger logger = LoggerFactory.getLogger(SearchStatistics.class);
    private Map<String, TestSuiteChromosome> bestIndividual = new HashMap<String, TestSuiteChromosome>();
    private StatisticsBackend backend = null;
    private Map<String, OutputVariable<?>> outputVariables = new TreeMap();
    private Map<String, ChromosomeOutputVariableFactory<?>> variableFactories = new TreeMap();
    private Map<String, SequenceOutputVariableFactory<?>> sequenceOutputVariableFactories = new TreeMap();
    private ClientState currentState = ClientState.INITIALIZATION;
    private long currentStateStarted = System.currentTimeMillis();
    private long searchStartTime = 0L;
    private long startTime = System.currentTimeMillis();
    private List<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();

    private SearchStatistics() {
        switch (Properties.STATISTICS_BACKEND) {
            case CONSOLE: {
                this.backend = new ConsoleStatisticsBackend();
                break;
            }
            case CSV: {
                this.backend = new CSVStatisticsBackend();
                break;
            }
            case HTML: {
                this.backend = new HTMLStatisticsBackend();
                break;
            }
            case DEBUG: {
                this.backend = new DebugStatisticsBackend();
                break;
            }
            default: {
                this.backend = null;
            }
        }
        this.initFactories();
        this.setOutputVariable(RuntimeVariable.Random_Seed, Randomness.getSeed());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.CoverageTimeline.name(), new CoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.FitnessTimeline.name(), new FitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.SizeTimeline.name(), new SizeSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LengthTimeline.name(), new LengthSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.TotalExceptionsTimeline.name(), (SequenceOutputVariableFactory<?>)new TotalExceptionsSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyBranchFitnessTimeline.name(), new OnlyBranchFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyBranchCoverageTimeline.name(), new OnlyBranchCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodTraceFitnessTimeline.name(), new MethodTraceFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodTraceCoverageTimeline.name(), new MethodTraceCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodFitnessTimeline.name(), new MethodFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodCoverageTimeline.name(), new MethodCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodNoExceptionFitnessTimeline.name(), new MethodNoExceptionFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodNoExceptionCoverageTimeline.name(), new MethodNoExceptionCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LineFitnessTimeline.name(), new LineFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LineCoverageTimeline.name(), new LineCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OutputFitnessTimeline.name(), new OutputFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OutputCoverageTimeline.name(), new OutputCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.ExceptionFitnessTimeline.name(), new ExceptionFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.ExceptionCoverageTimeline.name(), new ExceptionCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyMutationFitnessTimeline.name(), new OnlyMutationFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyMutationCoverageTimeline.name(), new OnlyMutationCoverageSequenceOutputVariableFactory());
        if (MasterServices.getInstance().getMasterNode() != null) {
            MasterServices.getInstance().getMasterNode().addListener(this);
        }
    }

    public static SearchStatistics getInstance() {
        if (instance == null) {
            instance = new SearchStatistics();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public void currentIndividual(String rmiClientIdentifier, Chromosome individual) {
        if (this.backend == null) {
            return;
        }
        logger.debug("Received individual");
        this.bestIndividual.put(rmiClientIdentifier, (TestSuiteChromosome)individual);
        for (ChromosomeOutputVariableFactory<?> chromosomeOutputVariableFactory : this.variableFactories.values()) {
            this.setOutputVariable(chromosomeOutputVariableFactory.getVariable((TestSuiteChromosome)individual));
        }
        for (SequenceOutputVariableFactory sequenceOutputVariableFactory : this.sequenceOutputVariableFactories.values()) {
            sequenceOutputVariableFactory.update((TestSuiteChromosome)individual);
        }
    }

    public void setOutputVariable(RuntimeVariable variable, Object value) {
        this.setOutputVariable(new OutputVariable(variable.toString(), value));
    }

    public void setOutputVariable(OutputVariable<?> variable) {
        if (this.sequenceOutputVariableFactories.containsKey(variable.getName())) {
            DirectSequenceOutputVariableFactory v = (DirectSequenceOutputVariableFactory)this.sequenceOutputVariableFactories.get(variable.getName());
            v.setValue((Number)((Integer)variable.getValue()));
        } else {
            this.outputVariables.put(variable.getName(), variable);
        }
    }

    public void addTestGenerationResult(List<TestGenerationResult> result) {
        this.results.add(result);
    }

    public List<List<TestGenerationResult>> getTestGenerationResults() {
        return this.results;
    }

    private List<String> getAllOutputVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        String[] essentials = new String[]{"TARGET_CLASS", "criterion", RuntimeVariable.Coverage.toString(), RuntimeVariable.Total_Goals.toString(), RuntimeVariable.Covered_Goals.toString()};
        variableNames.addAll(Arrays.asList(essentials));
        return variableNames;
    }

    private Collection<String> getOutputVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        if (Properties.OUTPUT_VARIABLES == null) {
            variableNames.addAll(this.getAllOutputVariableNames());
        } else {
            variableNames.addAll(Arrays.asList(Properties.OUTPUT_VARIABLES.split(",")));
        }
        return variableNames;
    }

    private Map<String, OutputVariable<?>> getOutputVariables(TestSuiteChromosome individual) {
        LinkedHashMap variables = new LinkedHashMap();
        for (String variableName : this.getOutputVariableNames()) {
            if (this.outputVariables.containsKey(variableName)) {
                variables.put(variableName, this.outputVariables.get(variableName));
                continue;
            }
            if (Properties.getParameters().contains(variableName)) {
                variables.put(variableName, new PropertyOutputVariableFactory(variableName).getVariable());
                continue;
            }
            if (this.variableFactories.containsKey(variableName)) {
                variables.put(variableName, this.variableFactories.get(variableName).getVariable(individual));
                continue;
            }
            if (this.sequenceOutputVariableFactories.containsKey(variableName)) {
                for (OutputVariable var : this.sequenceOutputVariableFactories.get(variableName).getOutputVariables()) {
                    variables.put(var.getName(), var);
                }
                continue;
            }
            logger.error("No obtained value for output variable: " + variableName);
            return null;
        }
        return variables;
    }

    public boolean writeStatistics() {
        logger.info("Writing statistics");
        if (this.backend == null) {
            return false;
        }
        this.outputVariables.put(RuntimeVariable.Total_Time.name(), new OutputVariable(RuntimeVariable.Total_Time.name(), (Object)(System.currentTimeMillis() - this.startTime)));
        if (this.bestIndividual.isEmpty()) {
            logger.error("No statistics has been saved because EvoSuite failed to generate any test case");
            return false;
        }
        TestSuiteChromosome individual = this.bestIndividual.values().iterator().next();
        Map<String, OutputVariable<?>> map = this.getOutputVariables(individual);
        if (map == null) {
            logger.error("Not going to write down statistics data, as some are missing");
            return false;
        }
        boolean valid = RuntimeVariable.validateRuntimeVariables(map);
        if (!valid) {
            logger.error("Not going to write down statistics data, as some data is invalid");
            return false;
        }
        this.backend.writeData((Chromosome)individual, map);
        return true;
    }

    public boolean writeStatisticsForAnalysis() {
        logger.info("Writing statistics");
        if (this.backend == null) {
            LoggingUtils.getEvoLogger().info("Backend is null");
            return false;
        }
        this.outputVariables.put(RuntimeVariable.Total_Time.name(), new OutputVariable(RuntimeVariable.Total_Time.name(), (Object)(System.currentTimeMillis() - this.startTime)));
        TestSuiteChromosome individual = new TestSuiteChromosome();
        Map<String, OutputVariable<?>> map = this.getOutputVariables(individual);
        if (map == null) {
            logger.error("Not going to write down statistics data, as some are missing");
            return false;
        }
        boolean valid = RuntimeVariable.validateRuntimeVariables(map);
        if (!valid) {
            logger.error("Not going to write down statistics data, as some data is invalid");
            return false;
        }
        this.backend.writeData((Chromosome)individual, map);
        return true;
    }

    public void receiveEvent(ClientStateInformation information) {
        if (information.getState() != this.currentState) {
            logger.info("Received status update: " + information);
            if (information.getState() == ClientState.SEARCH) {
                this.searchStartTime = System.currentTimeMillis();
                for (SequenceOutputVariableFactory<?> factory : this.sequenceOutputVariableFactories.values()) {
                    factory.setStartTime(this.searchStartTime);
                }
            }
            OutputVariable time = new OutputVariable("Time_" + this.currentState.getName(), (Object)(System.currentTimeMillis() - this.currentStateStarted));
            this.outputVariables.put(time.getName(), time);
            this.currentState = information.getState();
            this.currentStateStarted = System.currentTimeMillis();
        }
    }

    private void initFactories() {
        this.variableFactories.put(RuntimeVariable.Length.name(), new ChromosomeLengthOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Size.name(), new ChromosomeSizeOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Coverage.name(), new ChromosomeCoverageOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Fitness.name(), new ChromosomeFitnessOutputVariableFactory());
    }

    private static class OnlyMutationCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyMutationCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyMutationCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OnlyMutationSuiteFitness.class);
        }
    }

    private static class OnlyMutationFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyMutationFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyMutationFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OnlyMutationSuiteFitness.class);
        }
    }

    private static class ExceptionCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public ExceptionCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.ExceptionCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(ExceptionCoverageSuiteFitness.class);
        }
    }

    private static class ExceptionFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public ExceptionFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.ExceptionFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(ExceptionCoverageSuiteFitness.class);
        }
    }

    private static class OutputCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OutputCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OutputCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OutputCoverageSuiteFitness.class);
        }
    }

    private static class OutputFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OutputFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OutputFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OutputCoverageSuiteFitness.class);
        }
    }

    private static class LineCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public LineCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.LineCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(LineCoverageSuiteFitness.class);
        }
    }

    private static class LineFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public LineFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.LineFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(LineCoverageSuiteFitness.class);
        }
    }

    private static class RhoFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public RhoFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.RhoCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(RhoCoverageSuiteFitness.class);
        }
    }

    private static class MethodNoExceptionCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodNoExceptionCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodNoExceptionCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodNoExceptionCoverageSuiteFitness.class);
        }
    }

    private static class MethodNoExceptionFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodNoExceptionFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodNoExceptionFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodNoExceptionCoverageSuiteFitness.class);
        }
    }

    private static class MethodCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodCoverageSuiteFitness.class);
        }
    }

    private static class MethodFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodCoverageSuiteFitness.class);
        }
    }

    private static class MethodTraceCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodTraceCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodTraceCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodTraceCoverageSuiteFitness.class);
        }
    }

    private static class MethodTraceFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodTraceFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodTraceFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodTraceCoverageSuiteFitness.class);
        }
    }

    private static class OnlyBranchCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyBranchCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyBranchCoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OnlyBranchCoverageSuiteFitness.class);
        }
    }

    private static class OnlyBranchFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyBranchFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyBranchFitnessTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OnlyBranchCoverageSuiteFitness.class);
        }
    }

    private static class TotalExceptionsSequenceOutputVariableFactory
    extends DirectSequenceOutputVariableFactory<Integer> {
        public TotalExceptionsSequenceOutputVariableFactory() {
            super(RuntimeVariable.TotalExceptionsTimeline);
            this.value = 0;
        }

        public Integer getValue(TestSuiteChromosome individual) {
            return (Integer)this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }
    }

    private static class LengthSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Integer> {
        public LengthSequenceOutputVariableFactory() {
            super(RuntimeVariable.LengthTimeline);
        }

        public Integer getValue(TestSuiteChromosome individual) {
            return individual.totalLengthOfTestCases();
        }
    }

    private static class SizeSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Integer> {
        public SizeSequenceOutputVariableFactory() {
            super(RuntimeVariable.SizeTimeline);
        }

        public Integer getValue(TestSuiteChromosome individual) {
            return individual.size();
        }
    }

    private static class CoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public CoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.CoverageTimeline);
        }

        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverage();
        }
    }

    private static class FitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public FitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.FitnessTimeline);
        }

        protected Double getValue(TestSuiteChromosome individual) {
            return individual.getFitness();
        }
    }

    private static class ChromosomeCoverageOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Double> {
        public ChromosomeCoverageOutputVariableFactory() {
            super(RuntimeVariable.Coverage);
        }

        protected Double getData(TestSuiteChromosome individual) {
            return individual.getCoverage();
        }
    }

    private static class ChromosomeFitnessOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Double> {
        public ChromosomeFitnessOutputVariableFactory() {
            super(RuntimeVariable.Fitness);
        }

        protected Double getData(TestSuiteChromosome individual) {
            return individual.getFitness();
        }
    }

    private static class ChromosomeSizeOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Integer> {
        public ChromosomeSizeOutputVariableFactory() {
            super(RuntimeVariable.Size);
        }

        protected Integer getData(TestSuiteChromosome individual) {
            return individual.size();
        }
    }

    private static class ChromosomeLengthOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Integer> {
        public ChromosomeLengthOutputVariableFactory() {
            super(RuntimeVariable.Length);
        }

        protected Integer getData(TestSuiteChromosome individual) {
            return individual.totalLengthOfTestCases();
        }
    }
}

