/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileInputStream;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemHandlingTest {
    private static final boolean VFS = RuntimeSettings.useVFS;

    @After
    public void restoreProperties() {
        RuntimeSettings.useVFS = VFS;
    }

    @Test
    public void createNewFileByAddingData() throws IOException {
        RuntimeSettings.useVFS = true;
        Runtime.getInstance().resetRuntime();
        byte[] data = new byte[]{42, 66};
        EvoSuiteFile file = new EvoSuiteFile("foo");
        MockFile mf = new MockFile(file.getPath());
        Assert.assertFalse((boolean)mf.exists());
        FileSystemHandling.appendDataToFile((EvoSuiteFile)file, (byte[])data);
        Assert.assertTrue((boolean)mf.exists());
        MockFileInputStream in = new MockFileInputStream(file.getPath());
        byte[] buffer = new byte[4];
        int count = in.read(buffer);
        in.close();
        Assert.assertEquals((long)data.length, (long)count);
        Assert.assertEquals((long)data[0], (long)buffer[0]);
        Assert.assertEquals((long)data[1], (long)buffer[1]);
        Assert.assertEquals((long)0L, (long)buffer[2]);
        Assert.assertEquals((long)0L, (long)buffer[3]);
    }

    @Test
    public void createNewFileByAddingLine() throws IOException {
        RuntimeSettings.useVFS = true;
        Runtime.getInstance().resetRuntime();
        String data = "A new line to be added";
        EvoSuiteFile file = new EvoSuiteFile("foo");
        MockFile mf = new MockFile(file.getPath());
        Assert.assertFalse((boolean)mf.exists());
        FileSystemHandling.appendStringToFile((EvoSuiteFile)file, (String)data);
        Assert.assertTrue((boolean)mf.exists());
        MockFileInputStream in = new MockFileInputStream(file.getPath());
        byte[] buffer = new byte[1024];
        in.read(buffer);
        in.close();
        String byteString = new String(buffer);
        Assert.assertTrue((String)("Read: " + byteString), (boolean)byteString.startsWith(data));
        InputStreamReader reader = new InputStreamReader((InputStream)new MockFileInputStream(file.getPath()));
        char[] cbuf = new char[1024];
        reader.read(cbuf);
        reader.close();
        String charString = new String(cbuf);
        Assert.assertTrue((String)("Read: " + charString), (boolean)charString.startsWith(data));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new MockFileInputStream(file.getPath())));
        cbuf = new char[1024];
        bufferedReader.read(cbuf);
        bufferedReader.close();
        charString = new String(cbuf);
        Assert.assertTrue((String)("Read: " + charString), (boolean)charString.startsWith(data));
        Scanner fromFile = new Scanner((InputStream)new MockFileInputStream(file.getPath()));
        String fileContent = fromFile.nextLine();
        fromFile.close();
        Assert.assertEquals((Object)data, (Object)fileContent);
    }
}

