/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.TooManyResourcesException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoopCounterTest {
    @Before
    public void init() {
        LoopCounter.getInstance().reset();
    }

    @After
    public void tearDown() {
        LoopCounter.getInstance().reset();
    }

    @Test(timeout=10000L)
    public void testInfiniteLoop() {
        Assert.assertTrue((RuntimeSettings.maxNumberOfIterationsPerLoop > 0L ? 1 : 0) != 0);
        int first = LoopCounter.getInstance().getNewIndex();
        int second = LoopCounter.getInstance().getNewIndex();
        block2: while (true) {
            LoopCounter.getInstance().checkLoop(first);
            int i = 0;
            while (true) {
                if (i >= 100) continue block2;
                try {
                    LoopCounter.getInstance().checkLoop(second);
                }
                catch (TooManyResourcesException e) {
                    return;
                }
                ++i;
            }
            break;
        }
    }

    @Test
    public void testNoNewIndex() {
        LoopCounter.getInstance().checkLoop(0);
        LoopCounter.getInstance().checkLoop(1);
        LoopCounter.getInstance().checkLoop(2);
        LoopCounter.getInstance().checkLoop(5);
        LoopCounter.getInstance().checkLoop(6);
    }
}

