/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import org.evosuite.runtime.FalsePositiveException;
import org.evosuite.runtime.FooConstructor;
import org.evosuite.runtime.FooFields;
import org.evosuite.runtime.FooMethods;
import org.evosuite.runtime.PrivateAccess;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrivateAccessTest {
    @Before
    public void init() {
        PrivateAccess.setShouldNotFailTest((boolean)false);
    }

    @After
    public void tearDown() {
        PrivateAccess.setShouldNotFailTest((boolean)true);
    }

    @Test
    public void testPrivateConstructor() throws Throwable {
        FooConstructor.counter = 0;
        PrivateAccess.callDefaultConstructor(FooConstructor.class);
        Assert.assertTrue((FooConstructor.counter > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetField_serialVersionUID() {
        try {
            PrivateAccess.setVariable(FooFields.class, null, (String)"serialVersionUID", (Object)42L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetField_static() {
        PrivateAccess.setVariable(FooFields.class, null, (String)"n", (Object)42);
        Assert.assertEquals((long)42L, (long)FooFields.getN());
    }

    @Test
    public void testSetField_instance() {
        FooFields foo = new FooFields();
        PrivateAccess.setVariable(FooFields.class, (Object)foo, (String)"s", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)foo.getS());
    }

    @Test
    public void testSetField_error() {
        PrivateAccess.setShouldNotFailTest((boolean)true);
        PrivateAccess.setVariable(FooFields.class, null, (String)"a non-existing field", (Object)42);
        Assert.fail();
    }

    @Test
    public void testSetField_fail_on_error() {
        PrivateAccess.setShouldNotFailTest((boolean)false);
        try {
            PrivateAccess.setVariable(FooFields.class, null, (String)"a non-existing field", (Object)42);
            Assert.fail();
        }
        catch (FalsePositiveException e) {
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            PrivateAccess.setShouldNotFailTest((boolean)true);
        }
    }

    @Test
    public void testMethod_static() throws Throwable {
        FooMethods.n = 42;
        Integer res = (Integer)PrivateAccess.callMethod(FooMethods.class, null, (String)"getN", (Object[])new Object[0], (Class[])new Class[0]);
        Assert.assertEquals((long)42L, (long)res.intValue());
    }

    @Test
    public void testMethod_error() throws Throwable {
        PrivateAccess.setShouldNotFailTest((boolean)true);
        PrivateAccess.callMethod(FooMethods.class, null, (String)"a non-existing method", (Object[])new Object[0], (Class[])new Class[0]);
        Assert.fail();
    }

    @Test
    public void testMethod_fail_on_error() {
        PrivateAccess.setShouldNotFailTest((boolean)false);
        try {
            PrivateAccess.callMethod(FooMethods.class, null, (String)"a non-existing method", (Object[])new Object[0], (Class[])new Class[0]);
            Assert.fail();
        }
        catch (FalsePositiveException e) {
            Assert.fail();
        }
        catch (Throwable throwable) {
        }
        finally {
            PrivateAccess.setShouldNotFailTest((boolean)true);
        }
    }

    @Test
    public void testMethod_zero() throws Throwable {
        FooMethods foo = new FooMethods();
        foo.s = "bar";
        String s = (String)PrivateAccess.callMethod(FooMethods.class, (Object)foo, (String)"getS", (Object[])new Object[0], (Class[])new Class[0]);
        Assert.assertEquals((Object)"bar", (Object)s);
    }

    @Test
    public void testMethod_one() throws Throwable {
        FooMethods foo = new FooMethods();
        PrivateAccess.callMethod(FooMethods.class, (Object)foo, (String)"set", (Object[])new Object[]{"bar"}, (Class[])new Class[]{String.class});
        Assert.assertEquals((Object)"bar", (Object)foo.s);
    }

    @Test
    public void testMethod_sameMethod_but2parameters() throws Throwable {
        FooMethods foo = new FooMethods();
        FooMethods.n = 0;
        PrivateAccess.callMethod(FooMethods.class, (Object)foo, (String)"set", (Object[])new Object[]{"bar", 666}, (Class[])new Class[]{String.class, Integer.TYPE});
        Assert.assertEquals((Object)"bar", (Object)foo.s);
        Assert.assertEquals((long)666L, (long)FooMethods.n);
    }

    @Test
    public void testMethod_two_andReturn() throws Throwable {
        FooMethods foo = new FooMethods();
        String res = (String)PrivateAccess.callMethod(FooMethods.class, (Object)foo, (String)"compute", (Object[])new Object[]{"bar", 666}, (Class[])new Class[]{String.class, Integer.TYPE});
        Assert.assertEquals((Object)"bar666", (Object)res);
    }

    @Test
    public void testMethod_throwNPE() throws Throwable {
        try {
            PrivateAccess.callMethod(FooMethods.class, null, (String)"throwNPE", (Object[])new Object[0], (Class[])new Class[0]);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

