/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import javax.persistence.EntityManager;
import org.evosuite.runtime.javaee.db.DBManager;
import org.evosuite.runtime.javaee.db.KVPair;
import org.hibernate.internal.SessionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DBManagerIntTest {
    @Before
    public void init() {
        DBManager.getInstance().initDB();
    }

    @Test
    public void testTableInitialization() throws SQLException {
        Connection c = ((SessionImpl)DBManager.getInstance().getCurrentEntityManager().getDelegate()).connection();
        Statement s = c.createStatement();
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        ResultSet rs = s.executeQuery("select table_name from INFORMATION_SCHEMA.system_tables where table_type='TABLE' and table_schem='PUBLIC'");
        while (rs.next()) {
            if (rs.getString(1).startsWith("DUAL_")) continue;
            tables.add(rs.getString(1));
        }
        rs.close();
        s.close();
        Assert.assertTrue((boolean)tables.contains("KVPair_table".toUpperCase()));
    }

    @Test
    public void testDirectSQLModifications() throws SQLException {
        String tableName = "KVPair_table";
        Connection c = ((SessionImpl)DBManager.getInstance().getCurrentEntityManager().getDelegate()).connection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from " + tableName);
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        s.executeUpdate("INSERT INTO KVPair_table VALUES 'a', 'b'");
        rs = s.executeQuery("SELECT * from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        String a = rs.getString(1);
        String b = rs.getString(2);
        rs.close();
        Assert.assertEquals((Object)"a", (Object)a);
        Assert.assertEquals((Object)"b", (Object)b);
        s.executeUpdate("DELETE from " + tableName);
        rs = s.executeQuery("select * from " + tableName);
        Assert.assertFalse((boolean)rs.next());
        s.close();
    }

    @Test
    public void testDirectSQLInsertFollowedByClear() throws SQLException {
        String tableName = "KVPair_table";
        Connection c = ((SessionImpl)DBManager.getInstance().getCurrentEntityManager().getDelegate()).connection();
        Statement s = c.createStatement();
        ResultSet rs = null;
        s.executeUpdate("INSERT INTO KVPair_table VALUES 'a', 'b'");
        rs = s.executeQuery("SELECT * from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        rs.close();
        s.close();
        DBManager.getInstance().clearDatabase();
        s = c.createStatement();
        rs = s.executeQuery("SELECT * from " + tableName);
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        s.close();
    }

    @Test
    public void testClearDatabase() throws Exception {
        boolean cleared = false;
        DBManager.getInstance().initDB();
        cleared = DBManager.getInstance().clearDatabase();
        Assert.assertTrue((boolean)cleared);
        String key = "foo";
        String value = "bar";
        KVPair pair = new KVPair(key, value);
        EntityManager em = DBManager.getInstance().getCurrentEntityManager();
        em.getTransaction().begin();
        KVPair queried = null;
        queried = (KVPair)em.find(KVPair.class, (Object)key);
        Assert.assertNull((Object)queried);
        em.persist((Object)pair);
        queried = (KVPair)em.find(KVPair.class, (Object)key);
        Assert.assertNotNull((Object)queried);
        Assert.assertEquals((Object)value, (Object)queried.getValue());
        em.getTransaction().commit();
        EntityManager secondEM = DBManager.getInstance().getDefaultFactory().createEntityManager();
        queried = (KVPair)secondEM.find(KVPair.class, (Object)key);
        Assert.assertNotNull((Object)queried);
        secondEM.close();
        cleared = DBManager.getInstance().clearDatabase();
        Assert.assertTrue((boolean)cleared);
        EntityManager thirdEM = DBManager.getInstance().getDefaultFactory().createEntityManager();
        queried = (KVPair)thirdEM.find(KVPair.class, (Object)key);
        Assert.assertNull((Object)queried);
        thirdEM.close();
        queried = (KVPair)em.find(KVPair.class, (Object)key);
        Assert.assertNotNull((Object)queried);
    }
}

