/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.event.Event;
import javax.faces.bean.ManagedProperty;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import javax.ws.rs.core.Context;
import javax.xml.ws.WebServiceRef;
import org.evosuite.runtime.FalsePositiveException;
import org.evosuite.runtime.javaee.injection.Injector;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class InjectorTest {
    @Test
    public void testInject_noTag() throws Exception {
        Foo foo = new Foo();
        try {
            Injector.inject((Object)foo, Foo.class, (String)"noTag", (Object)new Integer(1));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)foo.getNoTag());
    }

    @Test
    public void testInject_inject() throws Exception {
        Foo foo = new Foo();
        Injector.inject((Object)foo, Foo.class, (String)"injectField", (Object)new Integer(1));
        Assert.assertNotNull((Object)foo.getInjectField());
    }

    @Test
    public void testInject_persistence() throws Exception {
        Foo foo = new Foo();
        Injector.inject((Object)foo, Foo.class, (String)"persistence", (Object)new Integer(1));
        Assert.assertNotNull((Object)foo.getPersistence());
    }

    @Test
    public void testExecutePostConstruct() throws Exception {
        Foo foo = new Foo();
        Assert.assertFalse((boolean)foo.isInit());
        Injector.executePostConstruct((Object)foo, Foo.class);
        Assert.assertTrue((boolean)foo.isInit());
    }

    @Test
    public void testHasPostConstruct() {
        Assert.assertTrue((boolean)Injector.hasPostConstruct(Foo.class));
        Assert.assertFalse((boolean)Injector.hasPostConstruct(String.class));
    }

    @Test
    public void testInjection_EntityManager() {
        Foo foo = new Foo();
        Assert.assertNull((Object)foo.getPersistence());
        Assert.assertNull((Object)foo.getEM());
        Assert.assertTrue((boolean)Injector.hasEntityManager(Foo.class));
        Injector.injectEntityManager((Object)foo, Foo.class);
        Assert.assertNull((Object)foo.getPersistence());
        Assert.assertNotNull((Object)foo.getEM());
    }

    @Test
    public void testInjection_Event() {
        Foo foo = new Foo();
        Assert.assertNull((Object)foo.getEvent());
        Assert.assertTrue((boolean)Injector.hasEvent(Foo.class));
        Injector.injectEvent((Object)foo, Foo.class);
        Assert.assertNotNull((Object)foo.getEvent());
    }

    @Test
    public void testInjection_UserTransaction() {
        Foo foo = new Foo();
        Assert.assertNull((Object)foo.getUserTransaction());
        Assert.assertTrue((boolean)Injector.hasUserTransaction(Foo.class));
        Injector.injectUserTransaction((Object)foo, Foo.class);
        Assert.assertNotNull((Object)foo.getUserTransaction());
    }

    @Test
    public void testInjection_EMFactory() {
        Foo foo = new Foo();
        Assert.assertNull((Object)foo.getFactory());
        Assert.assertTrue((boolean)Injector.hasEntityManagerFactory(Foo.class));
        Injector.injectEntityManagerFactory((Object)foo, Foo.class);
        Assert.assertNotNull((Object)foo.getFactory());
    }

    @Test
    public void test_getGeneralFieldsToInject_Foo() {
        List list = Injector.getGeneralFieldsToInject(Foo.class);
        Assert.assertEquals((long)5L, (long)list.size());
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Field f : list) {
            names.add(f.getName());
        }
        Assert.assertTrue((boolean)names.contains("aString"));
        Assert.assertTrue((boolean)names.contains("injectField"));
        Assert.assertTrue((boolean)names.contains("persistence"));
        Assert.assertTrue((boolean)names.contains("springWired"));
        Assert.assertTrue((boolean)names.contains("aResource"));
    }

    @Test
    public void test_getGeneralFieldsToInject_Bar() {
        List list = Injector.getGeneralFieldsToInject(Bar.class);
        Assert.assertEquals((long)4L, (long)list.size());
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Field f : list) {
            names.add(f.getName());
        }
        Assert.assertTrue((boolean)names.contains("ejb"));
        Assert.assertTrue((boolean)names.contains("webServiceRef"));
        Assert.assertTrue((boolean)names.contains("managedProperty"));
        Assert.assertTrue((boolean)names.contains("context"));
    }

    @Test
    public void test_getGeneralFieldsToInject_subclass_differentField() {
        List list = Injector.getGeneralFieldsToInject(SubclassDifferentField.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"aDifferentString", (Object)((Field)list.get(0)).getName());
    }

    @Test
    public void test_getGeneralFieldsToInject_subclass_sameField() {
        List list = Injector.getGeneralFieldsToInject(SubclassSameField.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"aString", (Object)((Field)list.get(0)).getName());
    }

    @Test
    public void testValidateBean_A_invalid() {
        A a = new A();
        try {
            Injector.validateBean((Object)a, A.class);
            Assert.fail();
        }
        catch (FalsePositiveException falsePositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateBean_A_ok() {
        A a = new A();
        try {
            Injector.inject((Object)a, A.class, (String)"a", (Object)"foo");
            Injector.validateBean((Object)a, A.class);
        }
        catch (FalsePositiveException e) {
            Assert.fail();
        }
    }

    @Test
    public void testValidateBean_B_invalid_AB() {
        B b = new B();
        try {
            Injector.validateBean((Object)b, B.class);
            Assert.fail();
        }
        catch (FalsePositiveException falsePositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateBean_B_invalid_A() {
        B b = new B();
        try {
            Injector.inject((Object)b, B.class, (String)"b", (Object)"bar");
            Injector.validateBean((Object)b, B.class);
            Assert.fail();
        }
        catch (FalsePositiveException falsePositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateBean_B_invalid_B() {
        B b = new B();
        try {
            Injector.inject((Object)b, A.class, (String)"a", (Object)"foo");
            Injector.validateBean((Object)b, B.class);
            Assert.fail();
        }
        catch (FalsePositiveException falsePositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateBean_B_ok() {
        B b = new B();
        try {
            Injector.inject((Object)b, A.class, (String)"a", (Object)"foo");
            Injector.inject((Object)b, B.class, (String)"b", (Object)"bar");
            Injector.validateBean((Object)b, B.class);
        }
        catch (FalsePositiveException e) {
            Assert.fail();
        }
    }

    private static class Foo {
        private Object noTag;
        @PersistenceUnit
        private EntityManagerFactory factory;
        @Autowired
        private String springWired;
        @Resource
        private String aResource;
        @Inject
        private Event event;
        @Inject
        private UserTransaction userTransaction;
        @Inject
        private String aString;
        @Inject
        private Object injectField;
        @PersistenceContext
        private Object persistence;
        @PersistenceContext
        private EntityManager em;
        private boolean init = false;

        private Foo() {
        }

        @PostConstruct
        private void doInit() {
            this.init = true;
        }

        public boolean isInit() {
            return this.init;
        }

        public Object getNoTag() {
            return this.noTag;
        }

        public Object getInjectField() {
            return this.injectField;
        }

        public Object getPersistence() {
            return this.persistence;
        }

        public EntityManager getEM() {
            return this.em;
        }

        public UserTransaction getUserTransaction() {
            return this.userTransaction;
        }

        public Event getEvent() {
            return this.event;
        }

        public EntityManagerFactory getFactory() {
            return this.factory;
        }
    }

    private static class Bar {
        @EJB
        private Object ejb;
        @WebServiceRef
        private Object webServiceRef;
        @ManagedProperty(value="")
        private Object managedProperty;
        @Context
        private Object context;
        private Object noTag;

        private Bar() {
        }
    }

    private static class B
    extends A {
        @Resource
        private String b;

        private B() {
        }
    }

    private static class A {
        @Autowired
        private String a;

        private A() {
        }
    }

    private static class SubclassSameField
    extends Foo {
        @Inject
        private String aString;

        private SubclassSameField() {
        }
    }

    private static class SubclassDifferentField
    extends Foo {
        @Inject
        private String aDifferentString;

        private SubclassDifferentField() {
        }
    }
}

