/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Scanner;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletConfig;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletState;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoHttpServletRequest;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoHttpServletResponse;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpServletTest {
    @Before
    public void init() {
        TestDataJavaEE.getInstance().reset();
        EvoServletState.reset();
    }

    @Test
    public void testExecutedMethod() throws ServletException, IOException {
        final boolean[] val = new boolean[3];
        HttpServlet servlet = new HttpServlet(){

            public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                val[0] = true;
            }

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                val[1] = true;
            }

            public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                val[2] = true;
            }
        };
        EvoServletState.initServlet((Servlet)servlet);
        EvoHttpServletRequest req = EvoServletState.getRequest();
        req.asPOST();
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertTrue((boolean)val[0]);
        Assert.assertTrue((!val[1] ? 1 : 0) != 0);
        Assert.assertTrue((!val[2] ? 1 : 0) != 0);
        val[0] = false;
        EvoServletState.reset();
        EvoServletState.initServlet((Servlet)servlet);
        req = EvoServletState.getRequest();
        req.asGET();
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertTrue((!val[0] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)val[1]);
        Assert.assertTrue((!val[2] ? 1 : 0) != 0);
        val[1] = false;
        EvoServletState.reset();
        EvoServletState.initServlet((Servlet)servlet);
        req = EvoServletState.getRequest();
        req.asPUT();
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertTrue((!val[0] ? 1 : 0) != 0);
        Assert.assertTrue((!val[1] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)val[2]);
    }

    @Test
    public void testParts() throws ServletException, IOException {
        HttpServlet servlet = new HttpServlet(){

            public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                Collection parts = req.getParts();
                String s = "";
                for (Part p : parts) {
                    Scanner in = new Scanner(p.getInputStream());
                    s = s + in.nextLine();
                    in.close();
                }
                PrintWriter out = resp.getWriter();
                out.print(s);
                out.close();
            }
        };
        String msg0 = "foo";
        String msg1 = "bar";
        EvoServletState.initServlet((Servlet)servlet);
        EvoHttpServletRequest req = EvoServletState.getRequest();
        req.asPOST();
        req.asMultipartFormData();
        req.addPart(new EvoPart("first", msg0));
        req.addPart(new EvoPart("second", msg1));
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertTrue((TestDataJavaEE.getInstance().getViewOfParts().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)EvoServletState.getResponse().getBody().equals(msg0 + msg1));
    }

    @Test
    public void testContentType() throws ServletException, IOException {
        HttpServlet servlet = new HttpServlet(){

            public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                String contentType = req.getContentType();
                if (!contentType.equals("multipart/form-data")) {
                    resp.sendError(42);
                    return;
                }
                resp.flushBuffer();
            }
        };
        Assert.assertFalse((boolean)TestDataJavaEE.getInstance().wasContentTypeRead());
        EvoServletState.initServlet((Servlet)servlet);
        EvoHttpServletRequest req = EvoServletState.getRequest();
        req.asPOST();
        req.asTextXml();
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertTrue((boolean)TestDataJavaEE.getInstance().wasContentTypeRead());
        Assert.assertTrue((boolean)EvoServletState.getResponse().getBody().contains("42"));
        EvoServletState.reset();
        EvoServletState.initServlet((Servlet)servlet);
        req = EvoServletState.getRequest();
        req.asPOST();
        req.asMultipartFormData();
        Assert.assertFalse((boolean)EvoServletState.getResponse().isCommitted());
        servlet.service((ServletRequest)req, (ServletResponse)EvoServletState.getResponse());
        Assert.assertFalse((boolean)EvoServletState.getResponse().getBody().contains("42"));
        Assert.assertTrue((boolean)EvoServletState.getResponse().isCommitted());
    }

    @Test
    public void testSimpleScenarioWithParams() throws IOException {
        EvoHttpServletRequest req = new EvoHttpServletRequest();
        EvoHttpServletResponse res = new EvoHttpServletResponse();
        req.addParam("foo", "bar");
        PrintWriter out = res.getWriter();
        out.print(req.getParameter("foo"));
        res.flushBuffer();
        Assert.assertEquals((Object)"bar", (Object)res.getBody());
    }

    @Test
    public void testInitServlet() throws Exception {
        String delegate = "/result.jsp";
        Assert.assertFalse((boolean)TestDataJavaEE.getInstance().getViewOfDispatchers().contains("/result.jsp"));
        HttpServlet servlet = new HttpServlet(){

            public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/result.jsp");
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        };
        EvoHttpServletRequest req = new EvoHttpServletRequest();
        EvoHttpServletResponse resp = new EvoHttpServletResponse();
        try {
            servlet.service((ServletRequest)req, (ServletResponse)resp);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EvoServletConfig conf = new EvoServletConfig();
        servlet.init((ServletConfig)conf);
        try {
            servlet.service((ServletRequest)req, (ServletResponse)resp);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        conf.createDispatcher("/result.jsp");
        servlet.init((ServletConfig)conf);
        servlet.service((ServletRequest)req, (ServletResponse)resp);
        String body = resp.getBody();
        Assert.assertNotEquals((Object)"WARN: the response was not committed", (Object)body);
        Assert.assertTrue((body.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)body.contains("/result.jsp"));
        Assert.assertTrue((boolean)TestDataJavaEE.getInstance().getViewOfDispatchers().contains("/result.jsp"));
    }

    @Test
    public void testNoAsyn() throws ServletException {
        HttpServlet servlet = new HttpServlet(){

            public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            }
        };
        EvoServletState.initServlet((Servlet)servlet);
        boolean supported = EvoServletState.getRequest().isAsyncSupported();
        Assert.assertFalse((boolean)supported);
    }

    @Test
    public void testAsyn() throws ServletException, IOException {
        AnnotatedServlet_for_testAsyn servlet = new AnnotatedServlet_for_testAsyn();
        EvoServletState.initServlet((Servlet)servlet);
        boolean supported = EvoServletState.getRequest().isAsyncSupported();
        Assert.assertTrue((boolean)supported);
        servlet.service((ServletRequest)EvoServletState.getRequest(), (ServletResponse)EvoServletState.getResponse());
        String body = EvoServletState.getResponse().getBody();
        Assert.assertEquals((Object)"foo", (Object)body);
    }

    @WebServlet(value={"/bar"}, asyncSupported=true)
    private class AnnotatedServlet_for_testAsyn
    extends HttpServlet {
        private AnnotatedServlet_for_testAsyn() {
        }

        public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            AsyncContext context = req.startAsync();
            PrintWriter out = context.getResponse().getWriter();
            out.print("foo");
            out.close();
        }
    }
}

