/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.jvm;

import org.evosuite.runtime.jvm.ShutdownHookHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShutdownHookHandlerTest {
    @Before
    public void init() {
        ShutdownHookHandler.getInstance().initHandler();
    }

    @After
    public void tearDown() {
        ShutdownHookHandler.getInstance().processWasHalted();
    }

    @Test
    public void testAddHook() {
        int n = ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks();
        Runtime.getRuntime().addShutdownHook(new Thread(){});
        Assert.assertEquals((long)(n + 1), (long)ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks());
    }

    @Test
    public void testDoubleInit() {
        int n = ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks();
        Runtime.getRuntime().addShutdownHook(new Thread(){});
        ShutdownHookHandler.getInstance().initHandler();
        Assert.assertEquals((long)n, (long)ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks());
    }

    @Test
    public void testNormalExecution() {
        final int[] array = new int[1];
        int value = 42;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                array[0] = 42;
            }
        });
        Assert.assertNotEquals((long)42L, (long)array[0]);
        ShutdownHookHandler.getInstance().executeAddedHooks();
        Assert.assertEquals((long)42L, (long)array[0]);
    }

    @Test
    public void testExecutionWithException() {
        int n = ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                throw new IllegalStateException();
            }
        });
        try {
            ShutdownHookHandler.getInstance().executeAddedHooks();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)n, (long)ShutdownHookHandler.getInstance().getNumberOfAllExistingHooks());
    }
}

