/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock;

import java.util.List;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.lang.MockException;
import org.evosuite.runtime.mock.java.lang.MockRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MockListTest {
    private static final boolean DEFAULT_JVM = RuntimeSettings.mockJVMNonDeterminism;

    @After
    public void tearDown() {
        RuntimeSettings.mockJVMNonDeterminism = DEFAULT_JVM;
    }

    @Test
    public void checkGetJVMMocks() {
        RuntimeSettings.mockJVMNonDeterminism = false;
        List list = MockList.getList();
        Assert.assertFalse((boolean)list.contains(MockRuntime.class));
        Assert.assertFalse((boolean)list.contains(MockException.class));
        RuntimeSettings.mockJVMNonDeterminism = true;
        list = MockList.getList();
        Assert.assertTrue((boolean)list.contains(MockRuntime.class));
        Assert.assertTrue((boolean)list.contains(MockException.class));
    }

    @Test
    public void testShouldBeMocked() {
        RuntimeSettings.mockJVMNonDeterminism = true;
        Assert.assertTrue((boolean)(new MockException() instanceof OverrideMock));
        Assert.assertTrue((boolean)MockList.shouldBeMocked((String)Exception.class.getName()));
        Assert.assertTrue((boolean)(new MockRuntime() instanceof StaticReplacementMock));
        Assert.assertTrue((boolean)MockList.shouldBeMocked((String)Runtime.class.getName()));
    }
}

