/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.InputStream;
import java.util.Scanner;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.java.io.MockFileInputStream;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.io.MockFileReader;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.mock.java.io.MockPrintStream;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CharByteReadWriteTest {
    private static final boolean VFS = RuntimeSettings.useVFS;

    @Before
    public void init() {
        RuntimeSettings.useVFS = true;
        Runtime.getInstance().resetRuntime();
    }

    @After
    public void restoreProperties() {
        RuntimeSettings.useVFS = VFS;
    }

    @Test
    public void testReadWriteByte() throws Throwable {
        String file = "FileOutputStream_file.tmp";
        String expected = "testReadWriteByte";
        byte[] data = expected.getBytes();
        MockFileOutputStream out = new MockFileOutputStream(file);
        out.write(data, 0, data.length);
        out.flush();
        out.close();
        byte[] buffer = new byte[1024];
        MockFileInputStream in = new MockFileInputStream(file);
        int read = in.read(buffer);
        in.close();
        String result = new String(buffer, 0, read);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testReadWriteChar() throws Throwable {
        String file = "FileWriter_file.tmp";
        String expected = "testReadWriteChar";
        char[] data = expected.toCharArray();
        MockFileWriter out = new MockFileWriter(file);
        out.write(data, 0, data.length);
        out.flush();
        out.close();
        char[] buffer = new char[1024];
        MockFileReader in = new MockFileReader(file);
        int read = in.read(buffer);
        in.close();
        String result = new String(buffer, 0, read);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testPrintWriter() throws Throwable {
        String file = "PrintWriter_file.tmp";
        String expected = "testPrintWriter";
        MockPrintWriter out = new MockPrintWriter(file);
        out.println(expected);
        out.close();
        Scanner in = new Scanner((InputStream)new MockFileInputStream(file));
        String result = in.nextLine();
        in.close();
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testPrintStream() throws Throwable {
        String file = "PrintStream_file.tmp";
        String expected = "testPrintStream";
        MockPrintStream out = new MockPrintStream(file);
        out.println(expected);
        out.close();
        Scanner in = new Scanner((InputStream)new MockFileInputStream(file));
        String result = in.nextLine();
        in.close();
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

