/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.Assert;
import org.junit.Test;

public class MockFileTest {
    @Test
    public void testSamePath() {
        String name = "foo.txt";
        File real = new File(name);
        MockFile mock = new MockFile(name);
        Assert.assertEquals((Object)real.toString(), (Object)mock.toString());
        Assert.assertEquals((Object)real.getPath(), (Object)mock.getPath());
    }

    @Test
    public void testAssumptionOnConstructors_Real() {
        String name = "base";
        File base = new File(name);
        File emptyParent = new File("", name);
        File nullParent = new File((String)null, name);
        Assert.assertEquals((Object)base.getAbsolutePath(), (Object)nullParent.getAbsolutePath());
        Assert.assertTrue((base.getAbsolutePath().length() > name.length() + 1 ? 1 : 0) != 0);
        if (emptyParent.getAbsolutePath().startsWith("/")) {
            Assert.assertEquals((Object)("/" + name), (Object)emptyParent.getAbsolutePath());
        }
    }

    @Test
    public void testAssumptionOnConstructors_Mock() {
        String name = "base";
        MockFile base = new MockFile(name);
        MockFile emptyParent = new MockFile("", name);
        MockFile nullParent = new MockFile((String)null, name);
        Assert.assertEquals((Object)base.getAbsolutePath(), (Object)nullParent.getAbsolutePath());
        Assert.assertTrue((base.getAbsolutePath().length() > name.length() + 1 ? 1 : 0) != 0);
        if (emptyParent.getAbsolutePath().startsWith("/")) {
            Assert.assertEquals((Object)("/" + name), (Object)emptyParent.getAbsolutePath());
        }
    }
}

