/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockRandomAccessFile;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class MockRandomAccessFileTest {
    @Test
    public void testNoWritePermission() {
        MockFramework.enable();
        VirtualFileSystem.getInstance().resetSingleton();
        VirtualFileSystem.getInstance().init();
        String fileName = "foo_random_access.txt";
        MockRandomAccessFile ra = null;
        try {
            ra = new MockRandomAccessFile(fileName, "r");
            Assert.fail();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        MockFile file = new MockFile(fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            Assert.fail();
        }
        try {
            ra = new MockRandomAccessFile(fileName, "r");
        }
        catch (FileNotFoundException e1) {
            Assert.fail();
        }
        int LENGTH = 10;
        try {
            ra.setLength(10L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long size = -1L;
        try {
            ra.close();
            ra = new MockRandomAccessFile(fileName, "rw");
            ra.setLength(10L);
            size = ra.length();
            ra.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)10L, (long)size);
    }
}

