/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import org.evosuite.runtime.mock.java.net.EvoHttpURLConnection;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.Assert;
import org.junit.Test;

public class HttpTest {
    @Test
    public void testUrlParsingHttp() throws MalformedURLException {
        String location = "http://www.evosuite.org/index.html";
        URL url = MockURL.URL((String)location);
        Assert.assertEquals((Object)"/index.html", (Object)url.getFile());
        Assert.assertEquals((Object)"http", (Object)url.getProtocol());
    }

    @Test
    public void testHttpNotFound() throws Exception {
        String location = "http://www.evosuite.org/index.html";
        URL url = MockURL.URL((String)location);
        URLConnection connection = url.openConnection();
        Assert.assertTrue((boolean)(connection instanceof HttpURLConnection));
        EvoHttpURLConnection evo = (EvoHttpURLConnection)connection;
        evo.connect();
        Assert.assertEquals((long)404L, (long)evo.getResponseCode());
        try {
            evo.getInputStream();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testHttpOK() throws Exception {
        VirtualNetwork.getInstance().reset();
        Assert.assertEquals((long)0L, (long)VirtualNetwork.getInstance().getViewOfRemoteAccessedFiles().size());
        String text = "<html>Hello World!</html>";
        String location = "http://www.evosuite.org/index.html";
        URL url = MockURL.URL((String)location);
        VirtualNetwork.getInstance().addRemoteTextFile(url.toString(), text);
        URLConnection connection = url.openConnection();
        Assert.assertTrue((boolean)(connection instanceof HttpURLConnection));
        EvoHttpURLConnection evo = (EvoHttpURLConnection)connection;
        evo.connect();
        Assert.assertEquals((long)200L, (long)evo.getResponseCode());
        Scanner in = new Scanner(evo.getInputStream());
        String result = in.nextLine();
        Assert.assertEquals((Object)text, (Object)result);
        Assert.assertEquals((long)1L, (long)VirtualNetwork.getInstance().getViewOfRemoteAccessedFiles().size());
    }
}

