/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import org.evosuite.runtime.mock.java.net.MockNetworkInterface;
import org.evosuite.runtime.vnet.NetworkInterfaceState;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.Assert;
import org.junit.Test;

public class NetworkInterfaceTest {
    @Test
    public void test() throws SocketException {
        VirtualNetwork.getInstance().init();
        List list = VirtualNetwork.getInstance().getAllNetworkInterfaceStates();
        Assert.assertTrue((list.size() >= 2 ? 1 : 0) != 0);
        boolean loopback = false;
        boolean no_loopback = false;
        for (NetworkInterfaceState nis : list) {
            if (nis.isLoopback()) {
                loopback = true;
            } else {
                no_loopback = true;
            }
            Assert.assertNotNull((Object)nis.getNetworkInterface());
            Assert.assertNotNull((Object)nis.getNetworkInterface().getName());
            Assert.assertTrue((!nis.getNetworkInterface().getName().trim().isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((nis.getNetworkInterface().getIndex() > 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)loopback);
        Assert.assertTrue((boolean)no_loopback);
        int n = 0;
        Enumeration en = MockNetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            ++n;
            en.nextElement();
        }
        Assert.assertEquals((long)list.size(), (long)n);
    }
}

