/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Scanner;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.net.MockServerSocket;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketTest {
    @Before
    public void init() {
        MockFramework.enable();
        VirtualNetwork.getInstance().reset();
    }

    @Test
    public void testNotBound() throws IOException {
        MockServerSocket server = new MockServerSocket();
        try {
            server.accept();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int port = 42;
        server.bind((SocketAddress)new InetSocketAddress(port));
        Assert.assertTrue((boolean)server.isBound());
        try {
            server.accept();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        server.close();
    }

    @Test
    public void testCollidingBinding() throws IOException {
        MockServerSocket first = new MockServerSocket();
        int port = 42;
        first.bind((SocketAddress)new InetSocketAddress(port));
        MockServerSocket second = new MockServerSocket();
        try {
            second.bind((SocketAddress)new InetSocketAddress(port));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        second.bind((SocketAddress)new InetSocketAddress(port + 1));
        first.close();
        second.close();
    }

    @Test
    public void testIncomingConnection() throws IOException {
        MockServerSocket server = new MockServerSocket();
        String localAddress = "127.0.0.1";
        int localPort = 42;
        server.bind((SocketAddress)new InetSocketAddress(localAddress, localPort));
        String remoteAddress = "127.0.0.2";
        int remotePort = 1234;
        VirtualNetwork.getInstance().registerIncomingTcpConnection(remoteAddress, remotePort, localAddress, localPort);
        Socket socket = server.accept();
        Assert.assertNotNull((Object)socket);
        Assert.assertEquals((Object)remoteAddress, (Object)socket.getInetAddress().getHostAddress());
        Assert.assertEquals((long)remotePort, (long)socket.getPort());
        Assert.assertEquals((Object)localAddress, (Object)socket.getLocalAddress().getHostAddress());
        Assert.assertEquals((long)localPort, (long)socket.getLocalPort());
        server.close();
        socket.close();
    }

    @Test
    public void testReceiveAndReplyMessage() throws IOException {
        int n = VirtualNetwork.getInstance().getViewOfOpenedTcpConnections().size();
        Assert.assertEquals((long)0L, (long)n);
        MockServerSocket server = new MockServerSocket();
        String localAddress = "127.0.0.1";
        int localPort = 42;
        server.bind((SocketAddress)new InetSocketAddress(localAddress, localPort));
        n = VirtualNetwork.getInstance().getViewOfOpenedTcpConnections().size();
        Assert.assertEquals((long)0L, (long)n);
        String msg = "Hello World! Sent from mocked TCP connection";
        EvoSuiteLocalAddress addr = new EvoSuiteLocalAddress(localAddress, localPort);
        NetworkHandling.sendMessageOnTcp((EvoSuiteLocalAddress)addr, (String)msg);
        Socket socket = server.accept();
        Assert.assertNotNull((Object)socket);
        InputStream in = socket.getInputStream();
        Assert.assertNotNull((Object)in);
        Scanner inScan = new Scanner(in);
        String received = inScan.nextLine();
        inScan.close();
        Assert.assertEquals((Object)msg, (Object)received);
        String reply = "Reply to Hello Message";
        OutputStream out = socket.getOutputStream();
        out.write(reply.getBytes());
        n = VirtualNetwork.getInstance().getViewOfOpenedTcpConnections().size();
        Assert.assertEquals((long)1L, (long)n);
        NativeTcp connection = (NativeTcp)VirtualNetwork.getInstance().getViewOfOpenedTcpConnections().iterator().next();
        Assert.assertEquals((long)reply.length(), (long)connection.getAmountOfDataInRemoteBuffer());
        server.close();
    }
}

