/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Scanner;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockInetSocketAddress;
import org.evosuite.runtime.mock.java.net.MockSocket;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.RemoteTcpServer;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SocketTest {
    @Before
    public void init() {
        VirtualNetwork.getInstance().init();
    }

    @Test
    public void testNullConnect() throws IOException {
        MockSocket s = new MockSocket();
        try {
            s.connect(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectNoAnswer() throws IOException {
        InetAddress addr = MockInetAddress.getByName((String)"127.42.42.42");
        MockInetSocketAddress saddr = new MockInetSocketAddress(addr, 12345);
        MockSocket s = new MockSocket();
        try {
            s.connect((SocketAddress)saddr);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleConnection() throws IOException {
        String remoteHost = "127.42.0.42";
        int remotePort = 666;
        MockInetSocketAddress saddr = new MockInetSocketAddress(MockInetAddress.getByName((String)remoteHost), remotePort);
        MockSocket s = new MockSocket();
        RemoteTcpServer server = new RemoteTcpServer(new EndPointInfo(saddr.getAddress().getHostAddress(), saddr.getPort(), VirtualNetwork.ConnectionType.TCP));
        VirtualNetwork.getInstance().addRemoteTcpServer(server);
        String msgFromServer = "server";
        server.sendMessage(msgFromServer);
        s.connect((SocketAddress)saddr);
        String msgFromSUT = "SUT";
        s.getOutputStream().write(msgFromSUT.getBytes());
        String sutReceived = new Scanner(s.getInputStream()).nextLine();
        Assert.assertEquals((Object)msgFromServer, (Object)sutReceived);
        Assert.assertEquals((Object)msgFromSUT, (Object)server.getAllReceivedDataAsString());
        s.close();
    }

    @Test
    public void testOperationsWithNoException() throws Exception {
        MockSocket socket = new MockSocket();
        try {
            socket.getReuseAddress();
            int DEFAULT_RECEIVE_BUFFER_SIZE = socket.getReceiveBufferSize();
            int DEFAULT_SEND_BUFFER_SIZE = socket.getSendBufferSize();
            socket.getKeepAlive();
            socket.getOOBInline();
            socket.getSoLinger();
            socket.getTcpNoDelay();
            try {
                socket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                socket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                socket.getTrafficClass();
            }
            catch (SocketException socketException) {}
        }
        catch (SocketException se) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

