/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.net.MockDatagramSocket;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UdpTest {
    @Before
    public void setupMock() {
        MockFramework.enable();
    }

    @After
    public void tearDownMock() {
        MockFramework.disable();
    }

    @Test
    public void multiOpenings() throws Exception {
        int n = 10000;
        ArrayList<MockDatagramSocket> list = new ArrayList<MockDatagramSocket>(n);
        for (int i = 0; i < n; ++i) {
            byte[] data = "Hello".getBytes();
            DatagramPacket packet = new DatagramPacket(data, data.length, MockInetAddress.getByName((String)"255.255.255.255"), 12345);
            MockDatagramSocket socket = new MockDatagramSocket();
            socket.send(packet);
            list.add(socket);
        }
    }

    @Test
    public void testReceivePacket() throws Exception {
        int port = 12345;
        String host = "127.0.0.1";
        MockDatagramSocket socket = new MockDatagramSocket(port, InetAddress.getByName(host));
        byte[] data = new byte[]{42};
        NetworkHandling.sendUdpPacket((EvoSuiteLocalAddress)new EvoSuiteLocalAddress(host, port), (byte[])data);
        DatagramPacket p = new DatagramPacket(new byte[1], 1);
        socket.receive(p);
        byte[] received = p.getData();
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((long)42L, (long)received[0]);
    }

    @Test
    public void testNonBlockingRead() throws Exception {
        int port = 12345;
        String host = "127.0.0.1";
        MockDatagramSocket socket = new MockDatagramSocket(port, InetAddress.getByName(host));
        DatagramPacket p = new DatagramPacket(new byte[1], 1);
        try {
            socket.receive(p);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSendPacket() throws Exception {
        String first = "127.0.42.1";
        String second = "127.0.42.2";
        MockDatagramSocket socket = new MockDatagramSocket(500);
        byte[] data = new byte[]{};
        DatagramPacket packet = new DatagramPacket(data, 0, InetAddress.getByName(first), 1234);
        socket.send(packet);
        packet.setAddress(InetAddress.getByName(second));
        packet.setPort(4567);
        socket.send(packet);
        socket.send(packet);
        socket.send(packet);
        Map map = VirtualNetwork.getInstance().getCopyOfSentUDP();
        Assert.assertEquals((long)2L, (long)map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (((EndPointInfo)entry.getKey()).getHost().equals(first)) {
                Assert.assertEquals((long)1L, (long)((Integer)entry.getValue()).intValue());
                continue;
            }
            if (((EndPointInfo)entry.getKey()).getHost().equals(second)) {
                Assert.assertEquals((long)3L, (long)((Integer)entry.getValue()).intValue());
                continue;
            }
            Assert.fail();
        }
    }
}

