/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.naming;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.mock.javax.naming.MockInitialContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MockInitialContextTest {
    @Before
    public void init() {
        RuntimeSettings.useJEE = true;
        Runtime.getInstance().resetRuntime();
    }

    @Test
    public void testBasicLookupFail() {
        try {
            InitialContext ic = new InitialContext();
            ic.lookup("global/service/AClass!AnInterface");
            Assert.fail();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicBindAndLookup() {
        AClass foo = new AClass();
        try {
            InitialContext ic = new InitialContext();
            ic.bind("service", (Object)foo);
            Assert.fail();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Test
    public void testLookup() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "global/service/AClass!AnInterface";
        Object obj = ic.lookup(name);
        Assert.assertNull((Object)obj);
        Assert.assertEquals((long)1L, (long)TestDataJavaEE.getInstance().getViewOfLookedUpContextNames().size());
        Assert.assertEquals((Object)name, TestDataJavaEE.getInstance().getViewOfLookedUpContextNames().iterator().next());
    }

    @Test
    public void testBindingFailClass() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "global/service/AClass!aClassThatDoesNotExist";
        AClass k = new AClass();
        try {
            ic.bind(name, (Object)k);
            Assert.fail();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Test
    public void testBindingOKClass() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "global/service/AClass!" + AnInterface.class.getName();
        AClass k = new AClass();
        ic.bind(name, (Object)k);
    }

    @Test
    public void testBindAndLookup() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "global/service/AClass";
        Object obj = ic.lookup(name);
        Assert.assertNull((Object)obj);
        AClass k = new AClass();
        ic.bind(name, (Object)k);
        Object res = ic.lookup(name);
        Assert.assertEquals((Object)k, (Object)res);
    }

    @Test
    public void testFailDoubleBind() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "global/service/AClass";
        Object obj = ic.lookup(name);
        Assert.assertNull((Object)obj);
        AClass k = new AClass();
        ic.bind(name, (Object)k);
        try {
            ic.bind(name, (Object)k);
            Assert.fail();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Test
    public void testUnbind() throws Exception {
        MockInitialContext ic = new MockInitialContext();
        String name = "foo/service/AClass";
        AClass k = new AClass();
        ic.bind(name, (Object)k);
        Object res = ic.lookup(name);
        Assert.assertNotNull((Object)res);
        ic.unbind(name);
        res = ic.lookup(name);
        Assert.assertNull((Object)res);
    }

    private class AClass
    implements AnInterface {
        private AClass() {
        }
    }

    private static interface AnInterface {
    }
}

