/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.LogManager;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class MSecurityManagerTest {
    private static ExecutorService executor;
    private static MSecurityManager securityManager;

    @BeforeClass
    public static void initClass() {
        executor = Executors.newCachedThreadPool();
        securityManager = new MSecurityManager();
    }

    @AfterClass
    public static void doneWithClass() {
        executor.shutdownNow();
    }

    @Before
    public void initTest() {
        securityManager.apply();
        securityManager.goingToExecuteTestCase();
    }

    @After
    public void doneWithTestCase() {
        securityManager.goingToEndTestCase();
        securityManager.restoreDefaultManager();
    }

    @Test
    public void testSpecifyStreamHandler() throws Exception {
        File tmp = null;
        try {
            tmp = File.createTempFile("testFile_" + System.currentTimeMillis(), "txt");
            tmp.deleteOnExit();
            String text = "The answer is 42";
            BufferedWriter out = new BufferedWriter(new FileWriter(tmp));
            out.write("The answer is 42");
            out.flush();
            out.close();
            final String fileName = tmp.getAbsolutePath();
            Future<?> future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        URL url = new URL("file:" + fileName);
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        String input = in.readLine();
                        Assert.assertEquals((Object)"The answer is 42", (Object)input);
                        in.close();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
            });
            future.get(1000L, TimeUnit.MILLISECONDS);
            future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        URL url = new URL("file:" + fileName);
                        URLConnection connection = url.openConnection();
                        connection.setDoOutput(true);
                        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                        out.write("The answer is 42");
                        out.flush();
                        out.close();
                    }
                    catch (SecurityException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
            });
            try {
                future.get(1000L, TimeUnit.MILLISECONDS);
                Assert.fail();
            }
            catch (ExecutionException e) {
                if (!(e.getCause().getCause() instanceof UnknownServiceException)) {
                    Assert.fail((String)("Cause is " + e.getCause().getCause().getMessage()));
                }
            }
        }
        catch (Exception e) {
            if (tmp != null) {
                tmp.delete();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadButNotWriteOfFiles() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        File tmp = null;
        String text = "EvoSuite rock!";
        try {
            tmp = File.createTempFile("foo_" + System.currentTimeMillis(), "tmp");
            tmp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tmp));
            out.write("EvoSuite rock!");
            out.flush();
            out.close();
            final String fileName = tmp.getAbsolutePath();
            Future<?> future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        File reading = new File(fileName);
                        BufferedReader in = new BufferedReader(new FileReader(reading));
                        String input = in.readLine();
                        Assert.assertEquals((Object)"EvoSuite rock!", (Object)input);
                        in.close();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
            });
            future.get(1000L, TimeUnit.MILLISECONDS);
            future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                        out.write("EvoSuite rock!");
                        out.flush();
                        out.close();
                    }
                    catch (SecurityException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
            });
            try {
                future.get(1000L, TimeUnit.MILLISECONDS);
                Assert.fail();
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof SecurityException)) {
                    Assert.fail();
                }
            }
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public static File createTempDir() {
        int TEMP_DIR_ATTEMPTS = 10000;
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    @Test
    public void cannotCreateDeleteDirectory() throws InterruptedException, ExecutionException, TimeoutException {
        File dir = MSecurityManagerTest.createTempDir();
        dir.deleteOnExit();
        Assert.assertTrue((boolean)dir.exists());
        dir.delete();
        Thread.sleep(100L);
        Assert.assertTrue((!dir.exists() ? 1 : 0) != 0);
        final File toDelete = MSecurityManagerTest.createTempDir();
        toDelete.deleteOnExit();
        Assert.assertTrue((boolean)toDelete.exists());
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MSecurityManagerTest.createTempDir();
                    Assert.fail((String)"Failed to block creating a new dir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    toDelete.delete();
                    Assert.fail((String)"Failed to block deleting an existing dir");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        });
        future.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)toDelete.exists());
        toDelete.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testReadAndWriteOfProperties() throws InterruptedException, ExecutionException, TimeoutException {
        final String userDir = System.getProperty("user.dir");
        Assert.assertNotNull((Object)userDir);
        String rocks = "EvoSuite Rocks!";
        Assert.assertNotSame((Object)"EvoSuite Rocks!", (Object)userDir);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                String readUserDir = System.getProperty("user.dir");
                Assert.assertEquals((Object)userDir, (Object)readUserDir);
                System.setProperty("user.dir", "EvoSuite Rocks!");
            }
        });
        future.get(1000L, TimeUnit.MILLISECONDS);
        String modified = System.getProperty("user.dir");
        Assert.assertEquals((Object)"EvoSuite Rocks!", (Object)modified);
        try {
            securityManager.goingToEndTestCase();
            modified = System.getProperty("user.dir");
            Assert.assertEquals((Object)userDir, (Object)modified);
        }
        finally {
            securityManager.goingToExecuteTestCase();
        }
    }

    @Test
    public void testCanLoadSwingStuff() throws InterruptedException, ExecutionException, TimeoutException {
        LogManager.getLogManager();
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Class.forName("javax.swing.JFrame");
                }
                catch (ClassNotFoundException e) {
                    throw new Error(e);
                }
            }
        });
        future.get(1000L, TimeUnit.MILLISECONDS);
    }
}

