/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.sandbox;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.evosuite.runtime.sandbox.Foo;
import org.evosuite.runtime.sandbox.Sandbox;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SandboxFromJUnitTest {
    private static ExecutorService executor;

    @BeforeClass
    public static void initEvoSuiteFramework() {
        Assert.assertNull((Object)System.getSecurityManager());
        Sandbox.initializeSecurityManagerForSUT();
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void clearEvoSuiteFramework() {
        Assert.assertNotNull((Object)System.getSecurityManager());
        executor.shutdownNow();
        Sandbox.resetDefaultSecurityManager();
        Assert.assertNull((Object)System.getSecurityManager());
    }

    @Before
    public void initTest() {
        Sandbox.goingToExecuteSUTCode();
    }

    @After
    public void doneWithTestCase() {
        Sandbox.doneWithExecutingSUTCode();
    }

    @Test
    public void testExit() throws Exception {
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                Foo foo = new Foo();
                try {
                    foo.tryToExit();
                    Assert.fail();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        });
        future.get(5000L, TimeUnit.MILLISECONDS);
    }
}

