/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.testdata;

import java.net.DatagramPacket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.net.MockDatagramSocket;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.MockServerSocket;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkHandlingTest {
    private static final boolean VNET = RuntimeSettings.useVNET;

    @Before
    public void init() {
        RuntimeSettings.useVNET = true;
        VirtualNetwork.getInstance().reset();
        MockFramework.enable();
    }

    @After
    public void tearDown() {
        RuntimeSettings.useVNET = VNET;
        MockFramework.disable();
    }

    @Test(timeout=500L)
    public void testOpenedRemoteTCP() throws Exception {
        EvoSuiteLocalAddress addr = new EvoSuiteLocalAddress("127.42.42.42", 42);
        NetworkHandling.sendDataOnTcp((EvoSuiteLocalAddress)addr, null);
        MockServerSocket sut = new MockServerSocket(addr.getPort(), 1, MockInetAddress.getByName((String)addr.getHost()));
        Socket socket = sut.accept();
        Assert.assertNotNull((Object)socket);
    }

    @Test(timeout=500L)
    public void testSendUdp() throws Exception {
        EvoSuiteLocalAddress sut = new EvoSuiteLocalAddress("127.42.42.42", 42);
        EvoSuiteRemoteAddress remote = new EvoSuiteRemoteAddress("127.62.62.62", 62);
        String msg = "foo";
        byte[] data = msg.getBytes();
        NetworkHandling.sendUdpPacket((EvoSuiteLocalAddress)sut, (EvoSuiteRemoteAddress)remote, (byte[])data);
        DatagramPacket packet = new DatagramPacket(new byte[10], 10);
        MockDatagramSocket socket = new MockDatagramSocket(sut.getPort(), MockInetAddress.getByName((String)sut.getHost()));
        socket.receive(packet);
        Assert.assertEquals((long)remote.getPort(), (long)packet.getPort());
        Assert.assertEquals((Object)remote.getHost(), (Object)packet.getAddress().getHostAddress());
        Assert.assertEquals((Object)msg, (Object)new String(packet.getData()));
    }

    @Test
    public void testURL() throws Exception {
        String text = "Hello World!";
        EvoSuiteURL url = new EvoSuiteURL("http://evosuite.org/hello.txt");
        NetworkHandling.createRemoteTextFile((EvoSuiteURL)url, (String)text);
        URL mock = MockURL.URL((String)url.getUrl());
        URLConnection connection = mock.openConnection();
        Scanner in = new Scanner(connection.getInputStream());
        String res = in.nextLine();
        Assert.assertEquals((Object)text, (Object)res);
    }
}

