/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.File;
import org.evosuite.runtime.util.JarPathing;
import org.junit.Assert;
import org.junit.Test;

public class JarPathingTest {
    @Test
    public void testBase() {
        String first = "target" + File.separator + "classes";
        String second = "target" + File.separator + "test-classes";
        String classpath = first + File.pathSeparator + second;
        Assert.assertFalse((boolean)JarPathing.containsAPathingJar((String)classpath));
        String pathing = JarPathing.createJarPathing((String)classpath);
        Assert.assertTrue((boolean)JarPathing.isPathingJar((String)pathing));
        String back = JarPathing.extractCPFromPathingJar((String)pathing);
        Assert.assertTrue((boolean)back.contains(first));
        Assert.assertTrue((boolean)back.contains(second));
    }

    @Test
    public void testSpace() throws Exception {
        String name = " a file with     many spaces.jar";
        File file = new File(name);
        if (!file.exists()) {
            Assert.assertTrue((boolean)file.createNewFile());
            file.deleteOnExit();
        }
        String pathing = JarPathing.createJarPathing((String)file.getAbsolutePath());
        String back = JarPathing.extractCPFromPathingJar((String)pathing);
        Assert.assertTrue((boolean)back.contains(file.getName()));
    }
}

