/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileInputStream;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VirtualFileSystemTest {
    @Before
    public void init() {
        MockFramework.enable();
        VirtualFileSystem.getInstance().resetSingleton();
        VirtualFileSystem.getInstance().init();
    }

    @After
    public void tearDown() {
        VirtualFileSystem.getInstance().resetSingleton();
    }

    @Test
    public void testTokenizeOnWindows() {
        String[] paths;
        for (String path : paths = new String[]{"C:\\foo\\single", "C:\\\\foo\\\\double", "C:\\foo\\\\mixed", "D:\\foo\\onD", "D:\\foo\\trail\\", "D:\\foo\\doubleTrail\\\\", "D:\\\\\\\\foo\\eight"}) {
            Object[] tokens = VirtualFileSystem.tokenize((String)path, (char)'\\');
            Assert.assertEquals((String)Arrays.toString(tokens), (long)3L, (long)tokens.length);
            for (Object token : tokens) {
                Assert.assertTrue((String)token, (!((String)token).contains("\\") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNoAccessByDefault() {
        Assert.assertEquals((long)0L, (long)VirtualFileSystem.getInstance().getAccessedFiles().size());
    }

    @Test
    public void testRename() throws IOException {
        MockFile bla = new MockFile("bla");
        MockFile doh = new MockFile("doh");
        Assert.assertFalse((boolean)bla.exists());
        Assert.assertFalse((boolean)doh.exists());
        boolean created = bla.createNewFile();
        Assert.assertTrue((boolean)created);
        Assert.assertTrue((boolean)bla.exists());
        Assert.assertFalse((boolean)doh.exists());
        boolean renamed = bla.renameTo((File)doh);
        Assert.assertTrue((boolean)renamed);
        Assert.assertFalse((boolean)bla.exists());
        Assert.assertTrue((boolean)doh.exists());
        MockFile inAnotherFolder = new MockFile("foo/hei/hello.tmp");
        Assert.assertFalse((boolean)inAnotherFolder.exists());
        renamed = doh.renameTo((File)inAnotherFolder);
        Assert.assertFalse((boolean)renamed);
        Assert.assertFalse((boolean)inAnotherFolder.exists());
        Assert.assertTrue((boolean)doh.exists());
        MockFile de = new MockFile("deeee");
        MockFile blup = new MockFile("blup");
        Assert.assertFalse((boolean)de.exists());
        Assert.assertFalse((boolean)blup.exists());
        renamed = de.renameTo((File)blup);
        Assert.assertFalse((boolean)renamed);
        Assert.assertFalse((boolean)de.exists());
        Assert.assertFalse((boolean)blup.exists());
    }

    @Test
    public void testReadAfterWriteToFile() throws IOException {
        File file = MockFile.createTempFile((String)"foo", (String)".tmp");
        Assert.assertTrue((boolean)file.exists());
        byte[] data = new byte[]{42, 66};
        MockFileOutputStream out = new MockFileOutputStream(file);
        out.write(data);
        out.close();
        MockFileInputStream in = new MockFileInputStream(file);
        byte[] buffer = new byte[4];
        int count = in.read(buffer);
        in.close();
        Assert.assertEquals((String)"End of stream should had been reached", (long)data.length, (long)count);
        Assert.assertEquals((long)data[0], (long)buffer[0]);
        Assert.assertEquals((long)data[1], (long)buffer[1]);
        Assert.assertEquals((long)0L, (long)buffer[2]);
        Assert.assertEquals((long)0L, (long)buffer[3]);
    }

    @Test
    public void testReadingNonExistingFile() throws IOException {
        String fileName = "this_file_should_not_exist";
        File realFile = new File(fileName);
        Assert.assertFalse((boolean)realFile.exists());
        try {
            MockFileInputStream in = new MockFileInputStream(realFile);
            Assert.fail();
        }
        catch (FileNotFoundException in) {
            // empty catch block
        }
        MockFile mockFile = new MockFile(fileName);
        Assert.assertFalse((boolean)mockFile.exists());
        try {
            MockFileInputStream in = new MockFileInputStream((File)mockFile);
            Assert.fail();
        }
        catch (FileNotFoundException in) {
            // empty catch block
        }
        boolean created = mockFile.createNewFile();
        Assert.assertTrue((boolean)created);
        Assert.assertTrue((boolean)mockFile.exists());
        Assert.assertFalse((boolean)realFile.exists());
        MockFileInputStream in = new MockFileInputStream((File)mockFile);
    }

    @Test
    public void testWriteToFile() throws IOException {
        String fileName = "foo_written_with_FOS";
        File realFile = new File(fileName);
        realFile.deleteOnExit();
        Assert.assertFalse((boolean)realFile.exists());
        MockFile file = new MockFile(fileName);
        Assert.assertFalse((boolean)file.exists());
        byte[] data = new byte[]{42};
        MockFileOutputStream out = new MockFileOutputStream((File)file);
        out.write(data);
        Assert.assertTrue((boolean)file.exists());
        out.close();
        try {
            out.write(data);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)realFile.exists());
    }

    @Test
    public void testTmpFileCreation() throws IOException {
        File file = MockFile.createTempFile((String)"foo", (String)".tmp");
        Assert.assertTrue((boolean)file.exists());
        String path = file.getAbsolutePath();
        System.out.println(path);
        Assert.assertTrue((String)path, (boolean)(path.contains("foo") & path.contains(".tmp")));
    }

    @Test
    public void testWorkingDirectoryExists() {
        MockFile workingDir = new MockFile(System.getProperty("user.dir"));
        Assert.assertTrue((boolean)workingDir.exists());
    }

    @Test
    public void testCreateDeleteFileDirectly() throws IOException {
        MockFile file = new MockFile("foo");
        Assert.assertFalse((boolean)file.exists());
        boolean created = file.createNewFile();
        Assert.assertTrue((boolean)created);
        Assert.assertTrue((boolean)file.exists());
        boolean deleted = file.delete();
        Assert.assertTrue((boolean)deleted);
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void testCreateDeleteFolderDirectly() throws IOException {
        MockFile folder = new MockFile("foo" + File.separator + "hello");
        Assert.assertFalse((boolean)folder.exists());
        boolean created = folder.mkdir();
        Assert.assertFalse((boolean)created);
        Assert.assertFalse((boolean)folder.exists());
        created = folder.mkdirs();
        Assert.assertTrue((boolean)created);
        Assert.assertTrue((boolean)folder.exists());
        MockFile file = new MockFile(folder.getAbsoluteFile() + File.separator + "evo");
        created = file.createNewFile();
        Assert.assertTrue((boolean)created);
        Assert.assertTrue((boolean)file.exists());
        boolean deleted = folder.delete();
        Assert.assertFalse((boolean)deleted);
        Assert.assertTrue((boolean)folder.exists());
        deleted = file.delete();
        Assert.assertTrue((boolean)deleted);
        Assert.assertFalse((boolean)file.exists());
        deleted = folder.delete();
        Assert.assertTrue((boolean)deleted);
        Assert.assertFalse((boolean)folder.exists());
    }
}

