/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import com.examples.with.different.packagename.agent.AbstractTime;
import com.examples.with.different.packagename.agent.ConcreteTime;
import com.examples.with.different.packagename.agent.ExtendingTimeC;
import com.examples.with.different.packagename.agent.GetFile;
import com.examples.with.different.packagename.agent.GetURL;
import com.examples.with.different.packagename.agent.SecondAbstractTime;
import com.examples.with.different.packagename.agent.SecondConcreteTime;
import com.examples.with.different.packagename.agent.SumRuntime;
import com.examples.with.different.packagename.agent.TimeA;
import com.examples.with.different.packagename.agent.TimeB;
import com.examples.with.different.packagename.agent.TimeC;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.EvoURLStreamHandler;
import org.evosuite.runtime.mock.java.net.URLUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstrumentingAgent_IT {
    private final boolean replaceCalls = RuntimeSettings.mockJVMNonDeterminism;
    private final boolean vfs = RuntimeSettings.useVFS;
    private final boolean vnet = RuntimeSettings.useVNET;

    @BeforeClass
    public static void initClass() {
        InstrumentingAgent.initialize();
    }

    @Before
    public void storeValues() {
        RuntimeSettings.mockJVMNonDeterminism = true;
        RuntimeSettings.useVFS = true;
        RuntimeSettings.useVNET = true;
        MethodCallReplacementCache.resetSingleton();
        Runtime.getInstance().resetRuntime();
    }

    @After
    public void resetValues() {
        RuntimeSettings.mockJVMNonDeterminism = this.replaceCalls;
        RuntimeSettings.useVFS = this.vfs;
        RuntimeSettings.useVNET = this.vnet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformationInClassExtendingAbstract() throws Exception {
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
            InstrumentingAgent.getInstrumentation().retransformClasses(AbstractTime.class, ConcreteTime.class);
            ConcreteTime time = new ConcreteTime();
            Assert.assertEquals((long)expected, (long)time.getTime());
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    @Test
    public void checkRetransformIsSupported() {
        Assert.assertTrue((boolean)InstrumentingAgent.getInstrumentation().isRetransformClassesSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailingTransformation() throws UnmodifiableClassException {
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
            InstrumentingAgent.getInstrumentation().retransformClasses(SecondAbstractTime.class, SecondConcreteTime.class);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        try {
            InstrumentingAgent.activate();
            SecondConcreteTime time = new SecondConcreteTime();
            Assert.assertNotEquals((long)expected, (long)time.getTime());
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTime() {
        long now = java.lang.System.currentTimeMillis();
        Assert.assertTrue((String)"", (TimeB.getTime() >= now ? 1 : 0) != 0);
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
            Assert.assertEquals((long)expected, (long)TimeA.getTime());
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    @Test
    public void testTransformationInAbstractClass() {
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformation() {
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
            TimeC time = new TimeC();
            Assert.assertEquals((long)expected, (long)time.getTime());
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformationInExtendingClass() {
        long expected = 42L;
        System.setCurrentTimeMillis((long)expected);
        try {
            InstrumentingAgent.activate();
            ExtendingTimeC time = new ExtendingTimeC();
            Assert.assertEquals((long)expected, (long)time.getTime());
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    @Test
    public void testInstrumentation() throws Exception {
        try {
            InstrumentingAgent.activate();
            Instrumentation inst = InstrumentingAgent.getInstrumentation();
            Assert.assertNotNull((Object)inst);
            ClassLoader loader = this.getClass().getClassLoader();
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(TimeA.class.getName())));
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(TimeB.class.getName())));
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(TimeC.class.getName())));
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(ExtendingTimeC.class.getName())));
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(ConcreteTime.class.getName())));
            Assert.assertTrue((boolean)inst.isModifiableClass(loader.loadClass(AbstractTime.class.getName())));
        }
        finally {
            InstrumentingAgent.deactivate();
        }
    }

    @Test
    public void testMockFramework_OverrideMock() {
        GetFile obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new GetFile();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        GetFile gf = obj;
        MockFramework.enable();
        Assert.assertTrue((boolean)(gf.get() instanceof MockFile));
        MockFramework.disable();
        Assert.assertFalse((boolean)(gf.get() instanceof MockFile));
    }

    @Test
    public void testMockFramework_StaticReplacementMock() {
        try {
            InstrumentingAgent.activate();
            new SumRuntime();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        MockFramework.enable();
        Assert.assertEquals((long)1101L, (long)SumRuntime.getSum());
        MockFramework.disable();
        Assert.assertFalse((SumRuntime.getSum() == 1101L ? 1 : 0) != 0);
    }

    @Test
    public void testMockFramework_StaticReplacementMock_ofConstructors() throws MalformedURLException {
        try {
            InstrumentingAgent.activate();
            new GetURL();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        MockFramework.disable();
        String url = "http://www.evosuite.org";
        URL res = GetURL.get(url);
        URLStreamHandler handler = URLUtil.getHandler((URL)res);
        Assert.assertFalse((boolean)(handler instanceof EvoURLStreamHandler));
        MockFramework.enable();
        res = GetURL.get(url);
        handler = URLUtil.getHandler((URL)res);
        Assert.assertTrue((boolean)(handler instanceof EvoURLStreamHandler));
    }

    @Test
    public void testMockFramework_StaticReplacementMock_2() throws Exception {
        try {
            InstrumentingAgent.activate();
            new GetURL();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        MockFramework.disable();
        String url = "http://www.evosuite.org";
        URL res = GetURL.getFromUri(url);
        URLStreamHandler handler = URLUtil.getHandler((URL)res);
        Assert.assertFalse((boolean)(handler instanceof EvoURLStreamHandler));
        MockFramework.enable();
        res = GetURL.getFromUri(url);
        handler = URLUtil.getHandler((URL)res);
        Assert.assertTrue((boolean)(handler instanceof EvoURLStreamHandler));
    }

    @Test
    public void testAddingInstrumentedClassInterface() {
        GetURL obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new GetURL();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        Assert.assertTrue((boolean)(obj instanceof InstrumentedClass));
    }

    @Test
    public void testMockFramework_noAgent() {
        MockFramework.enable();
        MockFile file = new MockFile("bar/foo");
        File parent = file.getParentFile();
        Assert.assertTrue((boolean)(parent instanceof MockFile));
        MockFramework.disable();
        parent = file.getParentFile();
        Assert.assertFalse((boolean)(parent instanceof MockFile));
    }
}

