/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import com.examples.with.different.packagename.agent.ExceptionHolder;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.lang.MockThrowable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstrumentingAgent_exceptionsIT {
    private final boolean replaceCalls = RuntimeSettings.mockJVMNonDeterminism;

    public static NullPointerException getNPE() {
        return new NullPointerException("This shouldn't be mocked");
    }

    @BeforeClass
    public static void initClass() {
        InstrumentingAgent.initialize();
    }

    @Before
    public void storeValues() {
        RuntimeSettings.mockJVMNonDeterminism = true;
        MethodCallReplacementCache.resetSingleton();
        Runtime.getInstance().resetRuntime();
    }

    @After
    public void resetValues() {
        RuntimeSettings.mockJVMNonDeterminism = this.replaceCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptions() {
        ExceptionHolder obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new ExceptionHolder();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        try {
            MockFramework.enable();
            ExceptionHolder eh = obj;
            Assert.assertFalse((boolean)(eh.getNonMockedNPE() instanceof EvoSuiteMock));
            Assert.assertTrue((boolean)(eh.getMockedThrowable() instanceof EvoSuiteMock));
            StackTraceElement[] traces = new MockThrowable().getStackTrace();
            StackTraceElement[] a = eh.getTracesWhenCast();
            Assert.assertEquals((Object)traces[1], (Object)a[1]);
        }
        finally {
            MockFramework.disable();
        }
    }

    @Test
    public void testStaticClassExceptions() {
        ExceptionHolder.StaticPublicException obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new ExceptionHolder.StaticPublicException();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        try {
            MockFramework.enable();
            ExceptionHolder.StaticPublicException foo = obj;
            Assert.assertTrue((boolean)(foo instanceof EvoSuiteMock));
        }
        finally {
            MockFramework.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplacementCallInSubClassOfException() {
        ExceptionHolder obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new ExceptionHolder();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        try {
            MockFramework.enable();
            StackTraceElement[] traces = new MockThrowable().getStackTrace();
            ExceptionHolder eh = obj;
            StackTraceElement[] b = eh.getTraces();
            Assert.assertEquals((Object)traces[1], (Object)b[1]);
        }
        finally {
            MockFramework.disable();
        }
    }
}

