/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import com.examples.with.different.packagename.agent.InfiniteLoop;
import com.examples.with.different.packagename.agent.StartThreads;
import com.examples.with.different.packagename.agent.TimerClass;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.thread.KillSwitch;
import org.evosuite.runtime.thread.KillSwitchHandler;
import org.evosuite.runtime.thread.ThreadStopper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstrumentingAgent_threadIT {
    private final boolean replaceCalls = RuntimeSettings.mockJVMNonDeterminism;

    @BeforeClass
    public static void initClass() {
        InstrumentingAgent.initialize();
    }

    @Before
    public void storeValues() {
        KillSwitchHandler.getInstance().setKillSwitch(false);
        RuntimeSettings.mockJVMNonDeterminism = true;
        MethodCallReplacementCache.resetSingleton();
        Runtime.getInstance().resetRuntime();
    }

    @After
    public void resetValues() {
        RuntimeSettings.mockJVMNonDeterminism = this.replaceCalls;
        KillSwitchHandler.getInstance().setKillSwitch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooManyThreads() {
        StartThreads st;
        RuntimeSettings.maxNumberOfThreads = 100;
        StartThreads obj = null;
        try {
            InstrumentingAgent.activate();
            RuntimeSettings.className = StartThreads.class.getName();
            st = new StartThreads();
            st.exe(50);
            st.exe(49);
            obj = st;
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        st = obj;
        st.exe(2);
        try {
            MockFramework.enable();
            st.exe(2);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            MockFramework.disable();
        }
    }

    @Test
    public void testKillSwitch() throws InterruptedException {
        RuntimeSettings.mockJVMNonDeterminism = false;
        InfiniteLoop obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new InfiniteLoop();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        InfiniteLoop loop = obj;
        Thread t = loop.getInfiniteLoop();
        t.start();
        t.join(200L);
        Assert.assertTrue((boolean)t.isAlive());
        t.interrupt();
        t.join(200L);
        Assert.assertTrue((boolean)t.isAlive());
        KillSwitchHandler.getInstance().setKillSwitch(true);
        t.interrupt();
        t.join(500L);
        Assert.assertFalse((boolean)t.isAlive());
    }

    @Test
    public void testTimer() throws InterruptedException {
        ThreadStopper stopper = new ThreadStopper((KillSwitch)KillSwitchHandler.getInstance(), 1000L, new String[0]);
        stopper.storeCurrentThreads();
        stopper.startRecordingTime();
        TimerClass obj = null;
        try {
            InstrumentingAgent.activate();
            obj = new TimerClass();
        }
        finally {
            InstrumentingAgent.deactivate();
        }
        Thread.sleep(100L);
        Assert.assertTrue((boolean)this.isThreadRunning("foo"));
        RuntimeSettings.mockJVMNonDeterminism = false;
        stopper.killAndJoinClientThreads();
        Assert.assertTrue((boolean)this.isThreadRunning("foo"));
        RuntimeSettings.mockJVMNonDeterminism = true;
        stopper.storeCurrentThreads();
        stopper.startRecordingTime();
        stopper.killAndJoinClientThreads();
        Assert.assertFalse((boolean)this.isThreadRunning("foo"));
    }

    private boolean isThreadRunning(String name) {
        Thread thread = null;
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getName().equals(name)) continue;
            thread = t;
            break;
        }
        if (thread == null) {
            return false;
        }
        return thread.isAlive();
    }
}

