/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiSupport {
    private static final Logger logger = LoggerFactory.getLogger(GuiSupport.class);
    private static final boolean isDefaultHeadless = GraphicsEnvironment.isHeadless();
    private static Field headless;

    public static void setHeadless() {
        if (isDefaultHeadless) {
            return;
        }
        GuiSupport.setHeadless(true);
    }

    public static void initialize() {
        try {
            FileSystems.getDefault();
        }
        catch (Throwable t) {
            logger.error("Failed to load default file system: " + t.getMessage());
            return;
        }
        new JButton().getFontMetrics(new Font(null));
    }

    public static void restoreHeadlessMode() {
        if (GraphicsEnvironment.isHeadless() && !isDefaultHeadless) {
            GuiSupport.setHeadless(false);
        }
    }

    private static void setHeadless(boolean isHeadless) {
        System.setProperty("java.awt.headless", "" + isHeadless);
        try {
            headless.set(null, isHeadless);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ERROR: failed to change AWT Headless state: " + e.getMessage(), e);
        }
    }

    static {
        try {
            headless = GraphicsEnvironment.class.getDeclaredField("headless");
            headless.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("ERROR: failed to use reflection for AWT Headless state: " + e.getMessage(), e);
        }
    }
}

