/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.TooManyResourcesException;

public class LoopCounter {
    private static final LoopCounter singleton = new LoopCounter();
    private List<Long> counters = new LinkedList<Long>();

    private LoopCounter() {
    }

    public static LoopCounter getInstance() {
        return singleton;
    }

    public void reset() {
        this.counters.clear();
    }

    public int getNewIndex() {
        int index = this.counters.size();
        this.counters.add(0L);
        return index;
    }

    public void checkLoop(int index) throws TooManyResourcesException, IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Loop index cannot be negative");
        }
        if (RuntimeSettings.maxNumberOfIterationsPerLoop < 0L) {
            return;
        }
        int size = this.counters.size();
        if (index >= size) {
            for (int i = 0; i < 1 + (index - size); ++i) {
                this.counters.add(0L);
            }
        }
        assert (index < this.counters.size());
        long value = this.counters.get(index) + 1L;
        this.counters.set(index, value);
        if (value >= RuntimeSettings.maxNumberOfIterationsPerLoop) {
            this.reset();
            throw new TooManyResourcesException("Loop has been executed more times than the allowed " + RuntimeSettings.maxNumberOfIterationsPerLoop);
        }
    }
}

