/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.runtime.javaee.injection.InjectionList;
import org.junit.AssumptionViolatedException;

public class PrivateAccess {
    private static boolean shouldNotFailTest = true;

    public static void setShouldNotFailTest(boolean b) {
        shouldNotFailTest = b;
    }

    public static <T> void setVariable(Class<T> klass, T instance, String fieldName, Object value) throws IllegalArgumentException, AssumptionViolatedException {
        PrivateAccess.setVariable(klass, instance, fieldName, value, null);
    }

    public static <T> void setVariable(Class<?> klass, T instance, String fieldName, Object value, List<Class<? extends Annotation>> tagsToCheck) throws IllegalArgumentException, AssumptionViolatedException {
        if (klass == null) {
            throw new IllegalArgumentException("No specified class");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("No specified field name");
        }
        if (fieldName.equals("serialVersionUID")) {
            throw new IllegalArgumentException("It is not allowed to set serialVersionUID by reflection");
        }
        Field field = null;
        try {
            field = klass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            String message = "Field '" + fieldName + "' does not exist any more in class " + klass;
            if (shouldNotFailTest) {
                throw new AssumptionViolatedException(message);
            }
            throw new IllegalArgumentException(message);
        }
        assert (field != null);
        field.setAccessible(true);
        if (tagsToCheck != null) {
            boolean match = false;
            for (Annotation ann : field.getDeclaredAnnotations()) {
                Class<? extends Annotation> tag = ann.annotationType();
                if (!InjectionList.isValidForInjection(tag, tagsToCheck)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new IllegalArgumentException("The field " + fieldName + " in class " + klass.getName() + "does not have any valid annotation");
            }
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new AssumptionViolatedException("Failed to set field " + fieldName + ": " + e.toString());
        }
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object[] inputs, Class<?>[] types) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        if (klass == null) {
            throw new IllegalArgumentException("No specified class");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("No specified method name");
        }
        if (types == null && inputs != null || types != null && inputs == null || types != null && inputs != null && types.length != inputs.length) {
            throw new IllegalArgumentException("Mismatch between input parameters and their type description");
        }
        Method method = null;
        try {
            method = klass.getDeclaredMethod(methodName, types);
        }
        catch (NoSuchMethodException e) {
            String message = "Method " + methodName + " does not exist anymore";
            if (shouldNotFailTest) {
                throw new AssumptionViolatedException(message);
            }
            throw new IllegalArgumentException(message);
        }
        assert (method != null);
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(instance, inputs);
        }
        catch (IllegalAccessException e) {
            throw new AssumptionViolatedException("Failed to call " + methodName + ": " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return result;
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[0], new Class[0]);
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object input, Class<?> type) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{input}, new Class[]{type});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1}, new Class[]{t0, t1});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2}, new Class[]{t0, t1, t2});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3}, new Class[]{t0, t1, t2, t3});
    }

    public static <T> Object callMethod(Class<T> klass, T instance, String methodName, Object i0, Class<?> t0, Object i1, Class<?> t1, Object i2, Class<?> t2, Object i3, Class<?> t3, Object i4, Class<?> t4) throws IllegalArgumentException, AssumptionViolatedException, Throwable {
        return PrivateAccess.callMethod(klass, instance, methodName, new Object[]{i0, i1, i2, i3, i4}, new Class[]{t0, t1, t2, t3, t4});
    }

    public static Method getCallMethod(int nParameters) {
        if (nParameters < 0 || nParameters > 5) {
            return null;
        }
        ArrayList<Class<Class>> types = new ArrayList<Class<Class>>();
        types.add(Class.class);
        types.add(Object.class);
        types.add(String.class);
        for (int i = 0; i < nParameters; ++i) {
            types.add(Object.class);
            types.add(Class.class);
        }
        try {
            return PrivateAccess.class.getDeclaredMethod("callMethod", types.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

