/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import org.evosuite.runtime.RuntimeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class System {
    private static final Logger logger = LoggerFactory.getLogger(System.class);
    private static boolean wasTimeAccessed = false;
    private static final Properties defaultProperties;
    private static final Set<String> systemProperties;
    private static volatile boolean needToRestoreProperties;
    private static final Set<String> readProperties;
    private static long currentTime;
    private static final Map<Integer, Integer> hashKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreProperties() {
        Properties properties = defaultProperties;
        synchronized (properties) {
            if (needToRestoreProperties) {
                java.lang.System.setProperties((Properties)defaultProperties.clone());
                needToRestoreProperties = false;
            }
        }
    }

    public static boolean wasAnyPropertyWritten() {
        return needToRestoreProperties;
    }

    public static boolean isSystemProperty(String property) {
        return systemProperties.contains(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handlePropertyPermission(PropertyPermission perm) {
        if (readProperties == null) {
            return true;
        }
        if (perm.getActions().contains("write")) {
            if (!RuntimeSettings.mockJVMNonDeterminism) {
                return !System.isSystemProperty(perm.getName());
            }
            Properties properties = defaultProperties;
            synchronized (properties) {
                needToRestoreProperties = true;
            }
        }
        String var = perm.getName();
        Set<String> set = readProperties;
        synchronized (set) {
            readProperties.add(var);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllPropertiesReadSoFar() {
        LinkedHashSet<String> copy = new LinkedHashSet<String>();
        Set<String> set = readProperties;
        synchronized (set) {
            copy.addAll(readProperties);
        }
        return copy;
    }

    public static void exit(int status) {
        wasTimeAccessed = true;
        throw new SystemExitException();
    }

    public static long currentTimeMillis() {
        wasTimeAccessed = true;
        return currentTime;
    }

    public static long getCurrentTimeMillisForVFS() {
        return currentTime;
    }

    public static void registerObjectForIdentityHashCode(Object o) {
        System.identityHashCode(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int identityHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        Map<Integer, Integer> map = hashKeys;
        synchronized (map) {
            Integer realId = java.lang.System.identityHashCode(o);
            if (!hashKeys.containsKey(realId)) {
                hashKeys.put(realId, hashKeys.size() + 1);
            }
            return hashKeys.get(realId);
        }
    }

    public static long nanoTime() {
        wasTimeAccessed = true;
        return currentTime * 1000L;
    }

    public static long freeMemory() {
        return 0L;
    }

    public static long maxMemory() {
        return 0L;
    }

    public static long totalMemory() {
        return 0L;
    }

    public static int availableProcessors() {
        return 0;
    }

    public static void setCurrentTimeMillis(long time) {
        currentTime = time;
    }

    public static void resetRuntime() {
        currentTime = 1392409281320L;
        wasTimeAccessed = false;
        hashKeys.clear();
        System.restoreProperties();
        needToRestoreProperties = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullReset() {
        System.resetRuntime();
        Set<String> set = readProperties;
        synchronized (set) {
            readProperties.clear();
        }
    }

    public static boolean wasTimeAccessed() {
        return wasTimeAccessed;
    }

    static {
        Properties prop = null;
        try {
            prop = (Properties)java.lang.System.getProperties().clone();
        }
        catch (Exception e) {
            logger.error("Error while initializing System: " + e.getMessage());
        }
        defaultProperties = prop;
        systemProperties = new HashSet<String>(Arrays.asList("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"));
        readProperties = new LinkedHashSet<String>();
        currentTime = 1392409281320L;
        hashKeys = new HashMap<Integer, Integer>();
    }

    public static class SystemExitException
    extends Error {
        private static final long serialVersionUID = 1L;
    }
}

