/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.agent.ToolsJarLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentLoader {
    private static final Logger logger = LoggerFactory.getLogger(AgentLoader.class);
    private static volatile boolean alreadyLoaded = false;

    public static synchronized void loadAgent() throws RuntimeException {
        if (alreadyLoaded) {
            return;
        }
        logger.info("dynamically loading javaagent");
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        String jarFilePath = AgentLoader.getJarPath();
        if (jarFilePath == null) {
            throw new RuntimeException("Cannot find either the compilation target folder nor the EvoSuite jar in classpath: " + System.getProperty("java.class.path"));
        }
        logger.info("Using JavaAgent in " + jarFilePath);
        ClassLoader toolLoader = new ToolsJarLocator(null).getLoaderForToolsJar();
        logger.info("Classpath: " + System.getProperty("java.class.path"));
        try {
            logger.info("Going to attach agent to process " + pid);
            AgentLoader.attachAgent(pid, jarFilePath, toolLoader);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String causeDescription = cause == null ? "" : " , cause " + cause.getClass() + " " + cause.getMessage();
            logger.error("Exception " + e.getClass() + ": " + e.getMessage() + causeDescription, e);
            try {
                Thread.sleep(5000L);
                logger.error("Trying again to attach agent:");
                logger.error("VM: " + nameOfRunningVM);
                logger.error("PID: " + pid);
                AgentLoader.attachAgent(pid, jarFilePath, toolLoader);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        alreadyLoaded = true;
    }

    private static void attachAgent(String pid, String jarFilePath, ClassLoader toolLoader) throws Exception {
        Class<?> string = toolLoader.loadClass("java.lang.String");
        Class<?> clazz = toolLoader.loadClass("com.sun.tools.attach.VirtualMachine");
        Method attach = clazz.getMethod("attach", string);
        Object instance = attach.invoke(null, pid);
        Method loadAgent = clazz.getMethod("loadAgent", string, string);
        loadAgent.invoke(instance, jarFilePath, "");
        Method detach = clazz.getMethod("detach", new Class[0]);
        detach.invoke(instance, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEvoSuiteMainJar(String path) throws IllegalArgumentException {
        if (path.endsWith("classes")) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("Non-existing file " + path);
        }
        String name = file.getName();
        if (!name.toLowerCase().contains("evosuite")) return false;
        if (!name.endsWith(".jar")) return false;
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            Attributes attributes = manifest.getMainAttributes();
            String agentClass = attributes.getValue("Agent-Class");
            String agent = InstrumentingAgent.class.getName();
            if (agentClass == null) return false;
            if (!agentClass.trim().equalsIgnoreCase(agent)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String getJarPath() {
        String classPath = System.getProperty("java.class.path");
        String jarFilePath = AgentLoader.searchInAClassPath(classPath);
        if (jarFilePath == null) {
            jarFilePath = AgentLoader.searchInCurrentClassLoaderIfUrlOne();
        }
        if (jarFilePath == null) {
            jarFilePath = AgentLoader.searchInCurrentClassLoaderIfItProvidesClasspathAPI();
        }
        if (jarFilePath == null) {
            jarFilePath = AgentLoader.searchInFolder("target");
        }
        if (jarFilePath == null) {
            jarFilePath = AgentLoader.searchInFolder("lib");
        }
        if (jarFilePath == null) {
            // empty if block
        }
        return jarFilePath;
    }

    private static String searchInAClassPath(String classPath) {
        String[] tokens;
        for (String entry : tokens = classPath.split(File.pathSeparator)) {
            if (entry == null || entry.isEmpty() || !AgentLoader.isEvoSuiteMainJar(entry)) continue;
            return entry;
        }
        return null;
    }

    private static String searchInCurrentClassLoaderIfItProvidesClasspathAPI() {
        for (ClassLoader loader = AgentLoader.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            try {
                Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
                String classPath = (String)m.invoke((Object)loader, new Object[0]);
                String jar = AgentLoader.searchInAClassPath(classPath);
                if (jar == null) continue;
                return jar;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String searchInCurrentClassLoaderIfUrlOne() {
        HashSet<URI> uris = new HashSet<URI>();
        for (ClassLoader loader = AgentLoader.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                try {
                    URI uri = url.toURI();
                    uris.add(uri);
                    File file = new File(uri);
                    if (!AgentLoader.isEvoSuiteMainJar(file.getAbsolutePath())) continue;
                    return file.getAbsolutePath();
                }
                catch (Exception e) {
                    logger.error("Error while parsing URL " + url);
                }
            }
        }
        String msg = "Failed to find EvoSuite jar in current classloader. URLs of classloader:";
        for (URI uri : uris) {
            msg = msg + "\n" + uri.toString();
        }
        logger.warn(msg);
        return null;
    }

    @Deprecated
    private static String searchInM2() {
        File home = new File(System.getProperty("user.home"));
        File m2 = new File(home.getAbsolutePath() + "/.m2");
        if (!m2.exists()) {
            logger.debug("Cannot find the .m2 folder in home directory in " + m2);
            return null;
        }
        String relativePath = "/repository/org/evosuite/evosuite/0.1-SNAPSHOT/evosuite-0.1-SNAPSHOT-jar-minimal.jar";
        File jar = new File(m2.getAbsolutePath() + relativePath);
        if (!jar.exists()) {
            logger.debug("No jar file at: " + jar);
            return null;
        }
        return jar.getAbsolutePath();
    }

    private static String searchInFolder(String folder) {
        File target = new File(folder);
        if (!target.exists()) {
            logger.debug("No target folder " + target.getAbsolutePath());
            return null;
        }
        if (!target.isDirectory()) {
            logger.debug("'target' exists, but it is not a folder");
            return null;
        }
        for (File file : target.listFiles()) {
            String path = file.getAbsolutePath();
            if (!AgentLoader.isEvoSuiteMainJar(path)) continue;
            return path;
        }
        return null;
    }
}

