/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.agent;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsJarLocator {
    private static final Logger logger = LoggerFactory.getLogger(ToolsJarLocator.class);
    private static final String EXAMPLE_CLASS = "com.sun.tools.attach.VirtualMachine";
    private String locationNotOnClasspath;
    private String manuallySpecifiedToolLocation;

    public ToolsJarLocator(String manuallySpecifiedToolLocation) {
        this.manuallySpecifiedToolLocation = manuallySpecifiedToolLocation;
    }

    public ClassLoader getLoaderForToolsJar() throws RuntimeException {
        try {
            Class.forName(EXAMPLE_CLASS, true, ClassLoader.getSystemClassLoader());
            logger.info("Tools.jar already on system classloader");
            return ClassLoader.getSystemClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName(EXAMPLE_CLASS);
                logger.info("Tools.jar already on current classloader");
                return ToolsJarLocator.class.getClassLoader();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (this.manuallySpecifiedToolLocation != null) {
                    return this.considerPathInProperties();
                }
                String javaHome = System.getProperty("java.home");
                ArrayList<String> locations = new ArrayList<String>(Arrays.asList(javaHome + "/../lib/tools.jar", javaHome + "/lib/tools.jar", javaHome + "/../Classes/classes.jar"));
                String javaHomeEnv = System.getenv("JAVA_HOME");
                if (javaHomeEnv != null && !javaHomeEnv.equals(javaHome)) {
                    locations.addAll(Arrays.asList(javaHomeEnv + "/../lib/tools.jar", javaHomeEnv + "/lib/tools.jar", javaHomeEnv + "/../Classes/classes.jar"));
                }
                for (String location : locations) {
                    File file = new File(location);
                    if (!file.exists()) continue;
                    return this.validateAndGetLoader(location);
                }
                throw new RuntimeException("Did not manage to automatically find tools.jar. Use -Dtools_jar_location=<path> property");
            }
        }
    }

    private ClassLoader considerPathInProperties() {
        if (!this.manuallySpecifiedToolLocation.endsWith(".jar")) {
            throw new RuntimeException("Property tools_jar_location does not point to a jar file: " + this.manuallySpecifiedToolLocation);
        }
        return this.validateAndGetLoader(this.manuallySpecifiedToolLocation);
    }

    private ClassLoader validateAndGetLoader(String location) {
        URLClassLoader loader = null;
        try {
            loader = URLClassLoader.newInstance(new URL[]{new File(location).toURI().toURL()}, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL: " + location, e);
        }
        try {
            Class.forName(EXAMPLE_CLASS, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Missing com.sun.tools.attach.VirtualMachine in " + location);
        }
        this.locationNotOnClasspath = location;
        return loader;
    }

    public String getLocationNotOnClasspath() {
        return this.locationNotOnClasspath;
    }
}

