/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.classhandling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.TooManyResourcesException;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassResetter {
    private static Logger logger = LoggerFactory.getLogger(ClassResetter.class);
    public static final String STATIC_RESET = "__STATIC_RESET";
    private static final ClassResetter instance = new ClassResetter();
    private ClassLoader loader;
    private final Map<ClassLoader, Map<String, Method>> resetMethodCache = new HashMap<ClassLoader, Map<String, Method>>();
    private final Set<String> alreadyLoggedErrors = new HashSet<String>();

    private ClassResetter() {
    }

    public static ClassResetter getInstance() {
        return instance;
    }

    public void setClassLoader(ClassLoader loader) throws IllegalArgumentException {
        if (loader == null) {
            throw new IllegalArgumentException("Null class loader");
        }
        this.loader = loader;
    }

    public synchronized void logWarn(String className, String msg) {
        if (this.alreadyLoggedErrors.contains(className)) {
            return;
        }
        this.alreadyLoggedErrors.add(className);
        logger.warn(msg);
    }

    private void cacheResetMethod(String classNameWithDots) {
        Map<String, Method> methodMap;
        if (!this.resetMethodCache.containsKey(this.loader)) {
            this.resetMethodCache.put(this.loader, new HashMap());
        }
        if ((methodMap = this.resetMethodCache.get(this.loader)).containsKey(classNameWithDots)) {
            return;
        }
        try {
            Class<?> clazz = this.loader.loadClass(classNameWithDots);
            if (clazz.isInterface() || clazz.isAnonymousClass()) {
                return;
            }
            Method m = clazz.getDeclaredMethod(STATIC_RESET, null);
            m.setAccessible(true);
            methodMap.put(classNameWithDots, m);
        }
        catch (NoSuchMethodException e) {
            logger.debug("__STATIC_RESET() method does not exists in class " + classNameWithDots);
        }
        catch (Error | Exception e) {
            this.logWarn(classNameWithDots, e.getClass() + " thrown while loading method  __STATIC_RESET() for class " + classNameWithDots);
        }
    }

    public Method getResetMethod(String classNameWithDots) {
        this.cacheResetMethod(classNameWithDots);
        return this.resetMethodCache.get(this.loader).get(classNameWithDots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String classNameWithDots) throws IllegalArgumentException, IllegalStateException {
        if (classNameWithDots == null || classNameWithDots.isEmpty()) {
            throw new IllegalArgumentException("Empty class name in input");
        }
        if (this.loader == null) {
            throw new IllegalStateException("No specified loader");
        }
        Method m = this.getResetMethod(classNameWithDots);
        if (m == null) {
            return;
        }
        boolean safe = Sandbox.isSafeToExecuteSUTCode();
        assert (!Sandbox.isSecurityManagerInitialized() || Sandbox.isOnAndExecutingSUTCode());
        InstrumentingAgent.activate();
        Runtime.getInstance().resetRuntime();
        try {
            if (!safe) {
                Sandbox.goingToExecuteUnsafeCodeOnSameThread();
            }
            m.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("" + e, e);
        }
        catch (NoClassDefFoundError e) {
            logger.error(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TooManyResourcesException) {
                this.logWarn(classNameWithDots, e.toString() + ", caused by: " + cause.toString());
            } else {
                StringWriter errors = new StringWriter();
                cause.printStackTrace(new PrintWriter(errors));
                this.logWarn(classNameWithDots, e.toString() + ", caused by: " + cause.toString() + "\n" + errors.toString());
            }
        }
        finally {
            if (!safe) {
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            }
        }
        InstrumentingAgent.deactivate();
    }
}

