/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvoClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(EvoClassLoader.class);
    private final RuntimeInstrumentation instrumentation;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public EvoClassLoader() {
        this(new RuntimeInstrumentation());
    }

    public EvoClassLoader(RuntimeInstrumentation instrumentation) {
        super(EvoClassLoader.class.getClassLoader());
        this.classLoader = EvoClassLoader.class.getClassLoader();
        this.instrumentation = instrumentation;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("<evosuite>".equals(name)) {
            throw new ClassNotFoundException();
        }
        if (!RuntimeInstrumentation.checkIfCanInstrument(name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        logger.info("Seeing class for first time: " + name);
        Class<?> instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        logger.info("Instrumenting class '" + fullyQualifiedTargetClass + "'.");
        InputStream is = null;
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            is = this.classLoader.getResourceAsStream(className + ".class");
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class" + "' should be in target project, but could not be found!");
            }
            byte[] byteBuffer = this.instrumentation.transformBytes(this, className, new ClassReader(is));
            this.createPackageDefinition(fullyQualifiedTargetClass);
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Keeping class: " + fullyQualifiedTargetClass);
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            logger.info("Error while loading class: " + t);
            throw new ClassNotFoundException(t.getMessage(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    private void createPackageDefinition(String className) {
        String pkgname;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = className.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
            logger.info("Defined package (3): " + this.getPackage(pkgname) + ", " + this.getPackage(pkgname).hashCode());
        }
    }

    public RuntimeInstrumentation getInstrumentation() {
        return this.instrumentation;
    }
}

