/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.MethodCallReplacement;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.StaticReplacementMethod;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.lang.MockThrowable;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallReplacementCache {
    private static final Logger logger = LoggerFactory.getLogger(MethodCallReplacementCache.class);
    private static final MethodCallReplacementCache instance = new MethodCallReplacementCache();
    private final Map<String, Map<String, MethodCallReplacement>> replacementCalls = new HashMap<String, Map<String, MethodCallReplacement>>();
    private final Map<String, Map<String, MethodCallReplacement>> specialReplacementCalls = new HashMap<String, Map<String, MethodCallReplacement>>();

    private MethodCallReplacementCache() {
        this.initReplacements();
    }

    public static MethodCallReplacementCache getInstance() {
        return instance;
    }

    public static void resetSingleton() {
        MethodCallReplacementCache.getInstance().replacementCalls.clear();
        MethodCallReplacementCache.getInstance().specialReplacementCalls.clear();
        MethodCallReplacementCache.getInstance().initReplacements();
    }

    private void addReplacementCall(MethodCallReplacement replacement) {
        if (!this.replacementCalls.containsKey(replacement.getClassName())) {
            this.replacementCalls.put(replacement.getClassName(), new HashMap());
        }
        this.replacementCalls.get(replacement.getClassName()).put(replacement.getMethodNameWithDesc(), replacement);
    }

    private void addSpecialReplacementCall(MethodCallReplacement replacement) {
        if (!this.specialReplacementCalls.containsKey(replacement.getClassName())) {
            this.specialReplacementCalls.put(replacement.getClassName(), new HashMap());
        }
        this.specialReplacementCalls.get(replacement.getClassName()).put(replacement.getMethodNameWithDesc(), replacement);
    }

    public boolean hasReplacementCall(String className, String methodNameWithDesc) {
        if (!this.replacementCalls.containsKey(className)) {
            return false;
        }
        return this.replacementCalls.get(className).containsKey(methodNameWithDesc);
    }

    public MethodCallReplacement getReplacementCall(String className, String methodNameWithDesc) {
        return this.replacementCalls.get(className).get(methodNameWithDesc);
    }

    public boolean hasSpecialReplacementCall(String className, String methodNameWithDesc) {
        if (!this.specialReplacementCalls.containsKey(className)) {
            return false;
        }
        return this.specialReplacementCalls.get(className).containsKey(methodNameWithDesc);
    }

    public MethodCallReplacement getSpecialReplacementCall(String className, String methodNameWithDesc) {
        return this.specialReplacementCalls.get(className).get(methodNameWithDesc);
    }

    private void initReplacements() {
        if (RuntimeSettings.mockJVMNonDeterminism) {
            this.addJavaLangCalls();
            this.addSecureRandomCalls();
            this.addGUICalls();
            this.addExtraceExceptionReplacements();
            this.addReplacementCall(new MethodCallReplacement("java/util/UUID", "randomUUID", "()Ljava/util/UUID;", 184, "org/evosuite/runtime/Random", "randomUUID", "()Ljava/util/UUID;", false, false));
        }
        this.handleMockList();
    }

    private void addExtraceExceptionReplacements() {
        List<Class> classes = Arrays.asList(IOException.class, Throwable.class, ArithmeticException.class, ArrayIndexOutOfBoundsException.class, ArrayStoreException.class, ClassCastException.class, ClassNotFoundException.class, CloneNotSupportedException.class, EnumConstantNotPresentException.class, Exception.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationException.class, InterruptedException.class, NegativeArraySizeException.class, NoSuchFieldException.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, ReflectiveOperationException.class, RuntimeException.class, SecurityException.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, UnsupportedOperationException.class, AbstractMethodError.class, AssertionError.class, BootstrapMethodError.class, ClassCircularityError.class, ClassFormatError.class, Error.class, ExceptionInInitializerError.class, IllegalAccessError.class, IncompatibleClassChangeError.class, InstantiationError.class, InternalError.class, LinkageError.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchMethodError.class, OutOfMemoryError.class, StackOverflowError.class, ThreadDeath.class, UnknownError.class, UnsatisfiedLinkError.class, UnsupportedClassVersionError.class, VerifyError.class, VirtualMachineError.class);
        for (Class k : classes) {
            String jvmOriginal = k.getName().replace('.', '/');
            String jvmMock = MockThrowable.class.getName().replace('.', '/');
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "getStackTrace", "()[Ljava/lang/StackTraceElement;", 182, jvmMock, "replacement_getStackTrace", "(Ljava/lang/Throwable;)[Ljava/lang/StackTraceElement;", false, false));
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "printStackTrace", "(Ljava/io/PrintStream;)V", 182, jvmMock, "replacement_printStackTrace", "(Ljava/lang/Throwable;Ljava/io/PrintStream;)V", false, false));
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "printStackTrace", "(Ljava/io/PrintWriter;)V", 182, jvmMock, "replacement_printStackTrace", "(Ljava/lang/Throwable;Ljava/io/PrintWriter;)V", false, false));
        }
    }

    private void handleMockList() {
        for (Class<? extends EvoSuiteMock> mock : MockList.getList()) {
            Class<?> mocked;
            String mockedName;
            if (OverrideMock.class.isAssignableFrom(mock)) {
                this.replaceAllConstructors(mock, mock.getSuperclass());
                this.replaceAllStaticMethods(mock, mock.getSuperclass());
                this.replaceAllInvokeSpecial(mock, mock.getSuperclass());
                this.handleStaticReplacementMethods(mock);
                continue;
            }
            if (!StaticReplacementMock.class.isAssignableFrom(mock)) continue;
            try {
                mockedName = ((StaticReplacementMock)mock.newInstance()).getMockedClassName();
            }
            catch (IllegalAccessException | InstantiationException e1) {
                logger.error("Cannot instantiate mock " + mock.getCanonicalName());
                continue;
            }
            try {
                mocked = StaticReplacementMock.class.getClassLoader().loadClass(mockedName);
            }
            catch (ClassNotFoundException e) {
                logger.error("Mock class " + mock.getCanonicalName() + " has non-existent mocked target " + mockedName);
                continue;
            }
            this.replaceAllStaticMethods(mock, mocked);
            this.replaceAllInstanceMethodsWithStatic(mock, mocked);
            this.replaceAllConstructorsWithStaticCalls(mock, mocked);
        }
    }

    private void handleStaticReplacementMethods(Class<? extends EvoSuiteMock> mockClass) {
        for (Method m : mockClass.getMethods()) {
            StaticReplacementMethod srm = m.getAnnotation(StaticReplacementMethod.class);
            if (srm == null) continue;
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("EvoSuite Bug: improper annotations in class " + mockClass.getName());
            }
            if (!OverrideMock.class.isAssignableFrom(mockClass)) {
                throw new RuntimeException("EvoSuite Bug: StaticReplacementMethod can only be used in OverrideMock");
            }
            String target = mockClass.getSuperclass().getCanonicalName();
            String desc = Type.getMethodDescriptor(m);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.replace('.', '/'), m.getName(), desc, 183, mockClass.getCanonicalName().replace('.', '/'), m.getName(), desc, false, false));
        }
    }

    private void addJavaLangCalls() {
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "exit", "(I)V", 184, "org/evosuite/runtime/System", "exit", "(I)V", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "currentTimeMillis", "()J", 184, "org/evosuite/runtime/System", "currentTimeMillis", "()J", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "nanoTime", "()J", 184, "org/evosuite/runtime/System", "nanoTime", "()J", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I", 184, "org/evosuite/runtime/System", "identityHashCode", "(Ljava/lang/Object;)I", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Object", "hashCode", "()I", 182, "org/evosuite/runtime/System", "identityHashCode", "(Ljava/lang/Object;)I", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Math", "random", "()D", 184, "org/evosuite/runtime/Random", "nextDouble", "()D", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getClasses", "()[Ljava/lang/Class;", 182, "org/evosuite/runtime/Reflection", "getClasses", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getAnnotations", "()[Ljava/lang/annotation/Annotation;", 182, "org/evosuite/runtime/Reflection", "getAnnotations", "(Ljava/lang/Class;)[Ljava/lang/annotation/Annotation;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", 182, "org/evosuite/runtime/Reflection", "getFields", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", 182, "org/evosuite/runtime/Reflection", "getConstructors", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", 182, "org/evosuite/runtime/Reflection", "getMethods", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredClasses", "()[Ljava/lang/Class;", 182, "org/evosuite/runtime/Reflection", "getDeclaredClasses", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredAnnotations", "()[Ljava/lang/annotation/Annotation;", 182, "org/evosuite/runtime/Reflection", "getDeclaredAnnotations", "(Ljava/lang/Class;)[Ljava/lang/annotation/Annotation;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", 182, "org/evosuite/runtime/Reflection", "getDeclaredFields", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", 182, "org/evosuite/runtime/Reflection", "getDeclaredConstructors", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", 182, "org/evosuite/runtime/Reflection", "getDeclaredMethods", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getInterfaces", "()[Ljava/lang/Class;", 182, "org/evosuite/runtime/Reflection", "getInterfaces", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
    }

    private void addGUICalls() {
        this.addReplacementCall(new MethodCallReplacement("javax/swing/JComponent", "getPreferredSize", "()Ljava/awt/Dimension;", 182, "org/evosuite/runtime/gui/JComponent", "getPreferredSize", "()Ljava/awt/Dimension;", true, false));
    }

    private void addRandomCalls() {
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextInt", "()I", 182, "org/evosuite/runtime/Random", "nextInt", "()I", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextInt", "(I)I", 182, "org/evosuite/runtime/Random", "nextInt", "(I)I", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextDouble", "()D", 182, "org/evosuite/runtime/Random", "nextDouble", "()D", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextFloat", "()F", 182, "org/evosuite/runtime/Random", "nextFloat", "()F", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextLong", "()J", 182, "org/evosuite/runtime/Random", "nextLong", "()J", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextGaussian", "()D", 182, "org/evosuite/runtime/Random", "nextGaussian", "()D", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextBoolean", "()Z", 182, "org/evosuite/runtime/Random", "nextBoolean", "()Z", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/util/Random", "nextBytes", "([B)V", 182, "org/evosuite/runtime/Random", "nextBytes", "([B)V", true, false));
    }

    private void addSecureRandomCalls() {
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextInt", "()I", 182, "org/evosuite/runtime/Random", "nextInt", "()I", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextInt", "(I)I", 182, "org/evosuite/runtime/Random", "nextInt", "(I)I", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextDouble", "()D", 182, "org/evosuite/runtime/Random", "nextDouble", "()D", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextFloat", "()F", 182, "org/evosuite/runtime/Random", "nextFloat", "()F", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextLong", "()J", 182, "org/evosuite/runtime/Random", "nextLong", "()J", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextGaussian", "()D", 182, "org/evosuite/runtime/Random", "nextGaussian", "()D", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextBoolean", "()Z", 182, "org/evosuite/runtime/Random", "nextBoolean", "()Z", true, false));
        this.addReplacementCall(new MethodCallReplacement("java/security/SecureRandom", "nextBytes", "([B)V", 182, "org/evosuite/runtime/Random", "nextBytes", "([B)V", true, false));
    }

    private void replaceAllInstanceMethodsWithStatic(Class<?> mockClass, Class<?> target) {
        for (Method m : target.getMethods()) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor(m);
            Type[] argumentTypes = Type.getArgumentTypes(m);
            Type[] mockedArgumentTypes = new Type[argumentTypes.length + 1];
            mockedArgumentTypes[0] = Type.getType(target);
            for (int i = 0; i < argumentTypes.length; ++i) {
                mockedArgumentTypes[i + 1] = argumentTypes[i];
            }
            String mockedDesc = Type.getMethodDescriptor(Type.getReturnType(m), mockedArgumentTypes);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), m.getName(), desc, 182, mockClass.getCanonicalName().replace('.', '/'), m.getName(), mockedDesc, false, false));
        }
    }

    private void replaceAllStaticMethods(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        for (Method m : target.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor(m);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), m.getName(), desc, 184, mockClass.getCanonicalName().replace('.', '/'), m.getName(), desc, false, false));
        }
    }

    private void replaceAllConstructors(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        if (!target.isAssignableFrom(mockClass)) {
            throw new IllegalArgumentException("Constructor replacement can be done only for subclasses. Class " + mockClass + " is not an instance of " + target);
        }
        for (Constructor<?> constructor : mockClass.getConstructors()) {
            String desc = Type.getConstructorDescriptor(constructor);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), "<init>", desc, 183, mockClass.getCanonicalName().replace('.', '/'), "<init>", desc, false, false));
        }
    }

    private void replaceAllConstructorsWithStaticCalls(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        for (Constructor<?> constructor : target.getConstructors()) {
            String desc = Type.getConstructorDescriptor(constructor);
            String replacementDesc = desc.substring(0, desc.length() - 1) + Type.getDescriptor(target);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), "<init>", desc, 183, mockClass.getCanonicalName().replace('.', '/'), target.getSimpleName(), replacementDesc, true, true));
        }
    }

    private void replaceAllInvokeSpecial(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        if (!target.isAssignableFrom(mockClass)) {
            throw new IllegalArgumentException("Method replacement can be done only for subclasses. Class " + mockClass + " is not an instance of " + target);
        }
        logger.debug("Static Mock: " + mockClass.getCanonicalName() + " for " + target.getCanonicalName());
        for (Method method : mockClass.getMethods()) {
            String desc = Type.getMethodDescriptor(method);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), method.getName(), desc, 183, mockClass.getCanonicalName().replace('.', '/'), method.getName(), desc, false, false));
        }
    }
}

