/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.AnnotatedClassNode;
import org.evosuite.runtime.instrumentation.CreateClassResetClassAdapter;
import org.evosuite.runtime.instrumentation.JSRInlinerClassVisitor;
import org.evosuite.runtime.instrumentation.KillSwitchClassAdapter;
import org.evosuite.runtime.instrumentation.LoopCounterClassAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.runtime.util.ComputeClassWriter;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstrumentation {
    private static Logger logger = LoggerFactory.getLogger(RuntimeInstrumentation.class);
    private volatile boolean retransformingMode = false;
    private static boolean avoidInstrumentingShadedClasses = false;

    public void setRetransformingMode(boolean on) {
        this.retransformingMode = on;
    }

    public static void setAvoidInstrumentingShadedClasses(boolean avoidInstrumentingShadedClasses) {
        RuntimeInstrumentation.avoidInstrumentingShadedClasses = avoidInstrumentingShadedClasses;
    }

    public static boolean checkIfCanInstrument(String className) {
        for (String s : RuntimeInstrumentation.getPackagesShouldNotBeInstrumented()) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        return !className.contains("EnhancerByMockito");
    }

    private static List<String> getPackagesShouldNotBeInstrumented() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList("java.", "javax.", "sun.", "org.evosuite", "org.exsyst", "de.unisb.cs.st.testcarver", "de.unisb.cs.st.evosuite", "org.uispec4j", "de.unisb.cs.st.specmate", "org.xml", "org.w3c", "testing.generation.evosuite", "com.yourkit", "com.vladium.emma.", "daikon.", "org.netbeans.lib.profiler", "apple.", "com.apple.", "com.sun", "org.junit", "junit.framework", "org.mockito", "org.apache.xerces.dom3", "de.unisl.cs.st.bugex", "org.mozilla.javascript.gen.c", "corina.cross.Single", "org.slf4j", "org.apache.log4j", "jdk.internal", "dk.brics.automaton", "org.apache.commons.discovery.tools.DiscoverSingleton", "org.apache.commons.discovery.resource.ClassLoaders", "org.apache.commons.discovery.resource.classes.DiscoverClasses", "org.evosuite.shaded.org.apache.commons.logging.Log", "org.jcp.xml.dsig.internal.dom.", "com_cenqua_clover", "com.cenqua", "net.sourceforge.cobertura", "javafx.", "ch.qos.logback", "major.mutation", "org.apache.lucene.util.SPIClassIterator", "org.apache.lucene.analysis.util.AnalysisSPILoader", "org.apache.lucene.analysis.util.CharFilterFactory", "org.apache.struts.util.MessageResources", "org.evosuite.shaded.org.dom4j.DefaultDocumentFactory"));
        if (avoidInstrumentingShadedClasses) {
            list.addAll(Arrays.asList("org.evosuite.shaded.org.hibernate", "org.evosuite.shaded.org.hsqldb", "org.evosuite.shaded.org.jboss", "org.evosuite.shaded.org.springframework", "org.evosuite.shaded.org.apache.commons.logging", "org.evosuite.shaded.javassist", "org.evosuite.shaded.antlr", "org.evosuite.shaded.org.dom4j", "org.evosuite.shaded.org.aopalliance"));
        }
        return list;
    }

    public byte[] transformBytes(ClassLoader classLoader, String className, ClassReader reader) {
        ComputeClassWriter writer;
        String classNameWithDots = className.replace("/", ".");
        if (!RuntimeInstrumentation.checkIfCanInstrument(classNameWithDots)) {
            throw new IllegalArgumentException("Should not transform a shared class (" + classNameWithDots + ")! Load by parent (JVM) classloader.");
        }
        int asmFlags = 2;
        ClassVisitor cv = writer = new ComputeClassWriter(asmFlags);
        if (RuntimeSettings.resetStaticState && !this.retransformingMode) {
            CreateClassResetClassAdapter resetClassAdapter = new CreateClassResetClassAdapter(cv, className);
            resetClassAdapter.setRemoveFinalModifierOnStaticFields(true);
            cv = resetClassAdapter;
        }
        if (RuntimeSettings.isUsingAnyMocking()) {
            cv = new MethodCallReplacementClassAdapter(cv, className, !this.retransformingMode);
        }
        cv = new KillSwitchClassAdapter(cv);
        if (RuntimeSettings.maxNumberOfIterationsPerLoop >= 0L) {
            cv = new LoopCounterClassAdapter(cv);
        }
        AnnotatedClassNode cn = new AnnotatedClassNode();
        int readFlags = 4;
        reader.accept(cn, readFlags);
        cv = new JSRInlinerClassVisitor(cv);
        try {
            cn.accept(cv);
        }
        catch (Throwable ex) {
            logger.error("Error while instrumenting class " + className + ": " + ex.getMessage(), ex);
        }
        return writer.toByteArray();
    }
}

