/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedHashSet;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.evosuite.runtime.javaee.javax.persistence.EvoEntityManagerFactory;
import org.evosuite.shaded.org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager {
    private static final Logger logger = LoggerFactory.getLogger(DBManager.class);
    private static final String EVOSUITE_DB = "EvoSuiteDB";
    private static final DBManager singleton = new DBManager();
    private EvoEntityManagerFactory factory;
    private EntityManager em;
    private boolean wasAccessed = false;
    private ClassLoader sutClassLoader;

    private DBManager() {
    }

    public static DBManager getInstance() {
        return singleton;
    }

    public boolean isWasAccessed() {
        return this.wasAccessed;
    }

    public EntityManagerFactory getDefaultFactory() {
        if (!this.wasAccessed) {
            this.initDB();
            this.wasAccessed = true;
        }
        return this.factory;
    }

    public EntityManager getCurrentEntityManager() {
        if (!this.wasAccessed) {
            this.initDB();
            this.wasAccessed = true;
        }
        return this.em;
    }

    private void createNewEntityManager() {
        this.em = this.factory.createEntityManager();
    }

    public boolean clearDatabase() {
        if (!this.wasAccessed) {
            return false;
        }
        try {
            Connection c = ((SessionImpl)this.em.getDelegate()).connection();
            Statement s = c.createStatement();
            s.execute("SET DATABASE REFERENTIAL INTEGRITY FALSE");
            LinkedHashSet<String> tables = new LinkedHashSet<String>();
            ResultSet rs = s.executeQuery("select table_name from INFORMATION_SCHEMA.system_tables where table_type='TABLE' and table_schem='PUBLIC'");
            while (rs.next()) {
                if (rs.getString(1).startsWith("DUAL_")) continue;
                tables.add(rs.getString(1));
            }
            rs.close();
            for (String table : tables) {
                String delete = "DELETE FROM " + table;
                s.executeUpdate(delete);
                logger.debug("SQL executed: " + delete);
            }
            s.execute("SET DATABASE REFERENTIAL INTEGRITY TRUE");
            s.close();
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to clear database: " + e.toString(), e);
            return false;
        }
    }

    public void initDB() {
        this.wasAccessed = true;
        if (this.factory == null) {
            this.factory = new EvoEntityManagerFactory();
            this.createNewEntityManager();
        } else {
            this.factory.clearAllEntityManagers();
            if (!this.factory.isOpen()) {
                this.factory = new EvoEntityManagerFactory();
            }
            this.createNewEntityManager();
            this.clearDatabase();
        }
    }

    public ClassLoader getSutClassLoader() {
        return this.sutClassLoader;
    }

    public void setSutClassLoader(ClassLoader sutClassLoader) {
        this.sutClassLoader = sutClassLoader;
    }
}

