/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.runtime.util.Inputs;

public class InjectionCache {
    private final Map<String, String> cache = new LinkedHashMap<String, String>();
    private final Class<?> fieldClass;
    private final List<Class<? extends Annotation>> annotations;

    public InjectionCache(Class<?> fieldClass, Class<? extends Annotation> ... annotations) {
        Inputs.checkNull(fieldClass, annotations);
        this.fieldClass = fieldClass;
        this.annotations = Collections.unmodifiableList(Arrays.asList(annotations));
    }

    public String getFieldName(Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(clazz);
        if (!this.hasField(clazz)) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a valid injectable field for " + this.fieldClass.getName());
        }
        String field = this.cache.get(clazz.getName());
        assert (field != null);
        return field;
    }

    public Field getField(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        if (!this.hasField(klass)) {
            return null;
        }
        try {
            return klass.getDeclaredField(this.cache.get(klass.getName()));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public boolean hasField(Class<?> klass) throws IllegalArgumentException {
        String f;
        Inputs.checkNull(klass);
        String className = klass.getName();
        if (!this.cache.containsKey(className)) {
            String fieldName = null;
            block0: for (Field field : klass.getDeclaredFields()) {
                if (!this.fieldClass.isAssignableFrom(field.getType())) continue;
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    for (Class<? extends Annotation> valid : this.annotations) {
                        if (!valid.isAssignableFrom(annotation.getClass())) continue;
                        fieldName = field.getName();
                        break block0;
                    }
                }
            }
            this.cache.put(className, fieldName);
        }
        return (f = this.cache.get(className)) != null;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }
}

