/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.shaded.org.springframework.beans.factory.annotation.Autowired;

public class InjectionList {
    private static final List<Class<? extends Annotation>> list = Collections.unmodifiableList(Arrays.asList(Inject.class, PersistenceContext.class, PersistenceUnit.class, Resource.class, Autowired.class));

    public static List<Class<? extends Annotation>> getList() {
        return list;
    }

    public static boolean isValidForInjection(Class<? extends Annotation> annotation) {
        return InjectionList.isValidForInjection(annotation, list);
    }

    public static boolean isValidForInjection(Class<? extends Annotation> annotation, List<Class<? extends Annotation>> tagsToCheck) {
        Inputs.checkNull(annotation);
        String name = annotation.getName();
        String shadedPrefix = "org.evosuite.shaded.";
        for (Class<? extends Annotation> c : tagsToCheck) {
            String cn = c.getName();
            if (name.equals(cn)) {
                return true;
            }
            if (!cn.startsWith(shadedPrefix) || !(shadedPrefix + name).equals(cn)) continue;
            return true;
        }
        return false;
    }
}

