/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import org.evosuite.runtime.PrivateAccess;
import org.evosuite.runtime.annotation.BoundInputVariable;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.javaee.db.DBManager;
import org.evosuite.runtime.javaee.injection.GeneralInjection;
import org.evosuite.runtime.javaee.injection.InjectionCache;
import org.evosuite.runtime.javaee.injection.InjectionList;
import org.evosuite.runtime.javaee.javax.enterprise.event.EvoEvent;
import org.evosuite.runtime.javaee.javax.transaction.EvoUserTransaction;
import org.evosuite.runtime.util.Inputs;
import org.junit.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injector {
    private static final Logger logger = LoggerFactory.getLogger(Injector.class);
    private static final Map<String, Method> postConstructCache = new LinkedHashMap<String, Method>();
    private static final InjectionCache entityManagerCache = new InjectionCache(EntityManager.class, Inject.class, PersistenceContext.class);
    private static final InjectionCache entityManagerFactoryCache = new InjectionCache(EntityManagerFactory.class, Inject.class, PersistenceUnit.class);
    private static final InjectionCache userTransactionCache = new InjectionCache(UserTransaction.class, Inject.class);
    private static final InjectionCache eventCache = new InjectionCache(Event.class, Inject.class);
    private static final GeneralInjection generalInjection = new GeneralInjection(entityManagerCache, entityManagerFactoryCache, userTransactionCache, eventCache);

    @EvoSuiteExclude
    public static void reset() {
        generalInjection.reset();
        postConstructCache.clear();
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static <T> void inject(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) T instance, Class<?> klass, String fieldName, Object value) throws IllegalArgumentException, AssumptionViolatedException {
        PrivateAccess.setVariable(klass, instance, fieldName, value, InjectionList.getList());
    }

    @EvoSuiteExclude
    public static List<Field> getAllFieldsToInject(Class<?> klass) {
        List<Field> fields = Injector.getGeneralFieldsToInject(klass);
        if (Injector.hasEntityManager(klass)) {
            fields.add(entityManagerCache.getField(klass));
        }
        if (Injector.hasEntityManagerFactory(klass)) {
            fields.add(entityManagerFactoryCache.getField(klass));
        }
        if (Injector.hasUserTransaction(klass)) {
            fields.add(userTransactionCache.getField(klass));
        }
        if (Injector.hasEvent(klass)) {
            fields.add(eventCache.getField(klass));
        }
        return fields;
    }

    @EvoSuiteExclude
    public static List<Field> getGeneralFieldsToInject(Class<?> klass) {
        return generalInjection.getFieldsToInject(klass);
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static <T> void injectEntityManager(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) T instance, Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(instance, clazz);
        String field = entityManagerCache.getFieldName(clazz);
        assert (field != null);
        Injector.inject(instance, clazz, field, DBManager.getInstance().getCurrentEntityManager());
    }

    @EvoSuiteExclude
    public static boolean hasEntityManager(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        return entityManagerCache.hasField(klass);
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static <T> void injectEntityManagerFactory(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) T instance, Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(instance, clazz);
        String field = entityManagerFactoryCache.getFieldName(clazz);
        assert (field != null);
        Injector.inject(instance, clazz, field, DBManager.getInstance().getDefaultFactory());
    }

    @EvoSuiteExclude
    public static boolean hasEntityManagerFactory(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        return entityManagerFactoryCache.hasField(klass);
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static <T> void injectUserTransaction(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) T instance, Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(instance, clazz);
        String field = userTransactionCache.getFieldName(clazz);
        assert (field != null);
        Injector.inject(instance, clazz, field, new EvoUserTransaction());
    }

    @EvoSuiteExclude
    public static boolean hasUserTransaction(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        return userTransactionCache.hasField(klass);
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static <T> void injectEvent(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) T instance, Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(instance, clazz);
        String field = eventCache.getFieldName(clazz);
        assert (field != null);
        Injector.inject(instance, clazz, field, new EvoEvent());
    }

    @EvoSuiteExclude
    public static boolean hasEvent(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        return eventCache.hasField(klass);
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static void executePostConstruct(@BoundInputVariable(initializer=true, atMostOnce=true) Object instance) throws IllegalArgumentException {
        Inputs.checkNull(instance);
        Injector.executePostConstruct(instance, instance.getClass());
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static void executePostConstruct(@BoundInputVariable(initializer=true, atMostOnceWithSameParameters=true) Object instance, Class<?> clazz) throws IllegalArgumentException {
        Inputs.checkNull(instance, clazz);
        if (!clazz.isAssignableFrom(instance.getClass())) {
            throw new IllegalArgumentException("Class " + clazz + " is not assignable from " + instance.getClass());
        }
        if (!Injector.hasPostConstruct(clazz)) {
            throw new IllegalArgumentException("The class " + clazz.getName() + " does not have a @PostConstruct");
        }
        Method m = postConstructCache.get(clazz.getName());
        assert (m != null);
        try {
            m.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.error(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to execute @PostConstructor in " + clazz.getName(), e);
        }
    }

    @EvoSuiteExclude
    public static boolean hasPostConstruct(Class<?> clazz) {
        Method m;
        String className = clazz.getName();
        if (!postConstructCache.containsKey(className)) {
            Method pc = null;
            block0: for (Method m2 : clazz.getDeclaredMethods()) {
                for (Annotation annotation : m2.getDeclaredAnnotations()) {
                    if (!(annotation instanceof PostConstruct)) continue;
                    pc = m2;
                    pc.setAccessible(true);
                    break block0;
                }
            }
            postConstructCache.put(className, pc);
        }
        return (m = postConstructCache.get(className)) != null;
    }
}

