/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.evosuite.runtime.annotation.EvoSuiteAssertionOnly;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;

@EvoSuiteClassExclude
public class EvoHttpServletResponse
implements HttpServletResponse {
    public static final String WARN_NO_COMMITTED = "WARN: the response was not committed";
    private final List<Byte> buffer = new ArrayList<Byte>();
    private int bufferSize = 1024;
    private boolean committed = false;
    private String encoding = "ISO-8859-1";
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;
    private String contentType = null;

    public void flushBuffer() throws IOException {
        this.committed = true;
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    @EvoSuiteAssertionOnly
    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException, IllegalStateException {
        if (this.writer != null) {
            throw new IllegalStateException("Get stream failed because get writer has already been called");
        }
        if (this.stream == null) {
            this.stream = new ServletOutputStream(){

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    EvoHttpServletResponse.this.buffer.add((byte)b);
                }

                public void flush() throws IOException {
                    EvoHttpServletResponse.this.committed = true;
                    super.flush();
                }

                public void close() throws IOException {
                    EvoHttpServletResponse.this.committed = true;
                    super.close();
                }
            };
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("Get writer failed because get stream has already been called");
        }
        this.writer = new PrintWriter((OutputStream)this.getOutputStream());
        return this.writer;
    }

    @EvoSuiteAssertionOnly
    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        this.buffer.clear();
        this.writer = null;
        this.stream = null;
    }

    public void setBufferSize(int arg0) {
        if (this.isCommitted() || this.buffer.size() > 0) {
            throw new IllegalStateException("Can only set buffer before writing any output");
        }
        if (arg0 > 0) {
            this.bufferSize = arg0;
        }
    }

    public void setCharacterEncoding(String arg0) {
        this.encoding = arg0;
    }

    public void setContentLength(int arg0) {
    }

    public void setContentLengthLong(long arg0) {
    }

    public void setContentType(String arg0) {
        this.contentType = arg0;
    }

    public void setLocale(Locale arg0) {
    }

    public void addCookie(Cookie arg0) {
    }

    public void addDateHeader(String arg0, long arg1) {
    }

    public void addHeader(String arg0, String arg1) {
    }

    public void addIntHeader(String arg0, int arg1) {
    }

    public boolean containsHeader(String arg0) {
        return false;
    }

    public String encodeRedirectURL(String arg0) {
        return null;
    }

    public String encodeRedirectUrl(String arg0) {
        return null;
    }

    public String encodeURL(String arg0) {
        return null;
    }

    public String encodeUrl(String arg0) {
        return null;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public Collection<String> getHeaders(String arg0) {
        return null;
    }

    @EvoSuiteAssertionOnly
    public int getStatus() {
        return 0;
    }

    public void sendError(int arg0) throws IOException, IllegalStateException {
        this.sendError(arg0, "");
    }

    public void sendError(int arg0, String arg1) throws IOException, IllegalStateException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.contentType = "text/html";
        this.resetBuffer();
        PrintWriter out = this.getWriter();
        out.println("ERROR page. Code: " + arg0 + ". Message: " + arg1);
        out.close();
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String arg0, long arg1) {
    }

    public void setHeader(String arg0, String arg1) {
    }

    public void setIntHeader(String arg0, int arg1) {
    }

    public void setStatus(int arg0) {
    }

    public void setStatus(int arg0, String arg1) {
    }

    @EvoSuiteAssertionOnly
    public String getBody() {
        if (!this.isCommitted()) {
            return WARN_NO_COMMITTED;
        }
        byte[] data = new byte[this.buffer.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.buffer.get(i);
        }
        return new String(data);
    }
}

