/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.io.NativeMockedIO;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class EvoFileChannel
extends FileChannel {
    private final AtomicInteger position;
    private final String path;
    private final boolean isOpenForRead;
    private final boolean isOpenForWrite;
    private volatile boolean closed;
    private final Object readWriteMonitor = new Object();

    protected EvoFileChannel(AtomicInteger sharedPosition, String path, boolean isOpenForRead, boolean isOpenForWrite) {
        this.position = sharedPosition;
        this.path = path;
        this.isOpenForRead = isOpenForRead;
        this.isOpenForWrite = isOpenForWrite;
        this.closed = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.read(new ByteBuffer[]{dst}, 0, 1, this.position);
    }

    @Override
    public int read(ByteBuffer dst, long pos) throws IOException {
        if (pos < 0L) {
            throw new MockIllegalArgumentException("Negative position: " + pos);
        }
        AtomicInteger tmp = new AtomicInteger((int)pos);
        return this.read(new ByteBuffer[]{dst}, 0, 1, tmp);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.read(dsts, offset, length, this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(ByteBuffer[] dsts, int offset, int length, AtomicInteger posToUpdate) throws IOException {
        if (!this.isOpenForRead) {
            throw new NonReadableChannelException();
        }
        this.throwExceptionIfClosed();
        int counter = 0;
        Object object = this.readWriteMonitor;
        synchronized (object) {
            for (int j = offset; j < length; ++j) {
                ByteBuffer dst = dsts[j];
                int r = dst.remaining();
                for (int i = 0; i < r; ++i) {
                    int b = NativeMockedIO.read(this.path, posToUpdate);
                    if (b < 0) {
                        return -1;
                    }
                    if (this.closed) {
                        throw new AsynchronousCloseException();
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.close();
                        throw new ClosedByInterruptException();
                    }
                    dst.put((byte)b);
                    ++counter;
                }
            }
        }
        return counter;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.write(new ByteBuffer[]{src}, 0, 1, this.position);
    }

    @Override
    public int write(ByteBuffer src, long pos) throws IOException {
        if (pos < 0L) {
            throw new MockIllegalArgumentException("Negative position: " + pos);
        }
        AtomicInteger tmp = new AtomicInteger((int)pos);
        return this.write(new ByteBuffer[]{src}, 0, 1, tmp);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(srcs, offset, length, this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(ByteBuffer[] srcs, int offset, int length, AtomicInteger posToUpdate) throws IOException {
        if (!this.isOpenForWrite) {
            throw new NonWritableChannelException();
        }
        if (offset < 0 || offset > srcs.length || length < 0 || length > srcs.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.throwExceptionIfClosed();
        int counter = 0;
        byte[] buffer = new byte[1];
        Object object = this.readWriteMonitor;
        synchronized (object) {
            for (int j = offset; j < length; ++j) {
                ByteBuffer src = srcs[j];
                int r = src.remaining();
                for (int i = 0; i < r; ++i) {
                    byte b;
                    buffer[0] = b = src.get();
                    NativeMockedIO.writeBytes(this.path, posToUpdate, buffer, 0, 1);
                    ++counter;
                    if (this.closed) {
                        throw new AsynchronousCloseException();
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    this.close();
                    throw new ClosedByInterruptException();
                }
            }
        }
        return counter;
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.throwExceptionIfClosed();
        if (size < 0L) {
            throw new MockIllegalArgumentException();
        }
        if (!this.isOpenForWrite) {
            throw new NonWritableChannelException();
        }
        long currentSize = this.size();
        if (size < currentSize) {
            NativeMockedIO.setLength(this.path, this.position, size);
        }
        return this;
    }

    @Override
    public long position() throws IOException {
        this.throwExceptionIfClosed();
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
        return this.position.get();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new MockIllegalArgumentException();
        }
        this.throwExceptionIfClosed();
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
        this.position.set((int)newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        this.throwExceptionIfClosed();
        return NativeMockedIO.size(this.path);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.throwExceptionIfClosed();
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new MockIOException("transferTo is not supported yet");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new MockIOException("transferFrom is not supported yet");
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new MockIOException("MappedByteBuffer mocks are not supported yet");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new MockIOException("FileLock mocks are not supported yet");
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new MockIOException("FileLock mocks are not supported yet");
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.closed = true;
    }

    private void throwExceptionIfClosed() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }
}

