/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.javax.swing.filechooser.MockFileSystemView;

public class MockJFileChooser
extends JFileChooser
implements OverrideMock {
    private static final long serialVersionUID = 1062809726268959728L;
    private static final String uiClassID = "FileChooserUI";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    private static final String SHOW_HIDDEN_PROP = "awt.file.showHiddenFiles";
    private String dialogTitle = null;
    private String approveButtonText = null;
    private String approveButtonToolTipText = null;
    private int approveButtonMnemonic = 0;
    private Vector<FileFilter> filters = new Vector(5);
    private JDialog dialog = null;
    private int dialogType = 0;
    private int returnValue = -1;
    private JComponent accessory = null;
    private FileView fileView = null;
    private boolean controlsShown = true;
    private boolean useFileHiding = true;
    private transient PropertyChangeListener showFilesListener = null;
    private int fileSelectionMode = 0;
    private boolean multiSelectionEnabled = false;
    private boolean useAcceptAllFileFilter = true;
    private boolean dragEnabled = false;
    private FileFilter fileFilter = null;
    private FileSystemView fileSystemView = null;
    private File currentDirectory = null;
    private File selectedFile = null;
    private File[] selectedFiles;
    private boolean finishedInitializingSuperclass = true;

    public MockJFileChooser() {
        this((File)null, (FileSystemView)null);
    }

    public MockJFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath, (FileSystemView)null);
    }

    public MockJFileChooser(File currentDirectory) {
        this(currentDirectory, (FileSystemView)null);
    }

    public MockJFileChooser(FileSystemView fsv) {
        this((File)null, fsv);
    }

    public MockJFileChooser(File currentDirectory, FileSystemView fsv) {
        this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        this.setup(fsv);
        this.setCurrentDirectory(currentDirectory);
    }

    public MockJFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        this.setup(fsv);
        if (currentDirectoryPath == null) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(this.fileSystemView.createFileObject(currentDirectoryPath));
        }
    }

    @Override
    protected void setup(FileSystemView view) {
        if (!this.finishedInitializingSuperclass) {
            return;
        }
        this.installShowFilesListener();
        if (view == null) {
            view = MockFileSystemView.getFileSystemView();
        }
        this.setFileSystemView(view);
        this.updateUI();
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
        this.enableEvents(16L);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (!this.finishedInitializingSuperclass) {
            return;
        }
        File oldValue = this.currentDirectory;
        if (dir != null && !dir.exists()) {
            dir = this.currentDirectory;
        }
        if (dir == null) {
            dir = this.getFileSystemView().getDefaultDirectory();
        }
        if (this.currentDirectory != null && this.currentDirectory.equals(dir)) {
            return;
        }
        File prev = null;
        while (!this.isTraversable(dir) && prev != dir) {
            prev = dir;
            dir = this.getFileSystemView().getParentDirectory(dir);
        }
        this.currentDirectory = dir;
        this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, oldValue, this.currentDirectory);
    }

    private void installShowFilesListener() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Object showHiddenProperty = tk.getDesktopProperty(SHOW_HIDDEN_PROP);
        if (showHiddenProperty instanceof Boolean) {
            this.useFileHiding = (Boolean)showHiddenProperty == false;
            this.showFilesListener = new MockWeakPCL(this);
            tk.addPropertyChangeListener(SHOW_HIDDEN_PROP, this.showFilesListener);
        }
    }

    @Override
    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    @Override
    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    public void setSelectedFile(File file) {
        File oldValue = this.selectedFile;
        this.selectedFile = file;
        if (this.selectedFile != null) {
            if (file.isAbsolute() && !this.getFileSystemView().isParent(this.getCurrentDirectory(), this.selectedFile)) {
                this.setCurrentDirectory(this.selectedFile.getParentFile());
            }
            if (!this.isMultiSelectionEnabled() || this.selectedFiles == null || this.selectedFiles.length == 1) {
                this.ensureFileIsVisible(this.selectedFile);
            }
        }
        this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, oldValue, this.selectedFile);
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return (File[])this.selectedFiles.clone();
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        File[] oldValue = this.selectedFiles;
        if (selectedFiles == null || selectedFiles.length == 0) {
            selectedFiles = null;
            this.selectedFiles = null;
            this.setSelectedFile(null);
        } else {
            this.selectedFiles = (File[])selectedFiles.clone();
            this.setSelectedFile(this.selectedFiles[0]);
        }
        this.firePropertyChange(SELECTED_FILES_CHANGED_PROPERTY, oldValue, selectedFiles);
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public void changeToParentDirectory() {
        this.selectedFile = null;
        File oldValue = this.getCurrentDirectory();
        this.setCurrentDirectory(this.getFileSystemView().getParentDirectory(oldValue));
    }

    @Override
    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    @Override
    public void ensureFileIsVisible(File f) {
        this.getUI().ensureFileIsVisible(this, f);
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (this.dialog != null) {
            return -1;
        }
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
            this.setDialogType(2);
        }
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MockJFileChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.show();
        this.firePropertyChange("JFileChooserDialogIsClosingProperty", this.dialog, null);
        this.dialog.getContentPane().removeAll();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    private static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return MockJFileChooser.getWindowForComponent(parentComponent.getParent());
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        FileChooserUI ui = this.getUI();
        String title = ui.getDialogTitle(this);
        this.putClientProperty("AccessibleDescription", title);
        Window window = MockJFileChooser.getWindowForComponent(parent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.getRootPane().setDefaultButton(ui.getDefaultButton(this));
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    @Override
    public boolean getControlButtonsAreShown() {
        return this.controlsShown;
    }

    @Override
    public void setControlButtonsAreShown(boolean b) {
        if (this.controlsShown == b) {
            return;
        }
        boolean oldValue = this.controlsShown;
        this.controlsShown = b;
        this.firePropertyChange(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY, oldValue, this.controlsShown);
    }

    @Override
    public int getDialogType() {
        return this.dialogType;
    }

    @Override
    public void setDialogType(int dialogType) {
        if (this.dialogType == dialogType) {
            return;
        }
        if (dialogType != 0 && dialogType != 1 && dialogType != 2) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + dialogType);
        }
        int oldValue = this.dialogType;
        this.dialogType = dialogType;
        if (dialogType == 0 || dialogType == 1) {
            this.setApproveButtonText(null);
        }
        this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, oldValue, dialogType);
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        String oldValue = this.dialogTitle;
        this.dialogTitle = dialogTitle;
        if (this.dialog != null) {
            this.dialog.setTitle(dialogTitle);
        }
        this.firePropertyChange(DIALOG_TITLE_CHANGED_PROPERTY, oldValue, dialogTitle);
    }

    @Override
    public String getDialogTitle() {
        return this.dialogTitle;
    }

    @Override
    public void setApproveButtonToolTipText(String toolTipText) {
        if (this.approveButtonToolTipText == toolTipText) {
            return;
        }
        String oldValue = this.approveButtonToolTipText;
        this.approveButtonToolTipText = toolTipText;
        this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, oldValue, this.approveButtonToolTipText);
    }

    @Override
    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    @Override
    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    @Override
    public void setApproveButtonMnemonic(int mnemonic) {
        if (this.approveButtonMnemonic == mnemonic) {
            return;
        }
        int oldValue = this.approveButtonMnemonic;
        this.approveButtonMnemonic = mnemonic;
        this.firePropertyChange(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY, oldValue, this.approveButtonMnemonic);
    }

    @Override
    public void setApproveButtonMnemonic(char mnemonic) {
        int vk = mnemonic;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        this.setApproveButtonMnemonic(vk);
    }

    @Override
    public void setApproveButtonText(String approveButtonText) {
        if (this.approveButtonText == approveButtonText) {
            return;
        }
        String oldValue = this.approveButtonText;
        this.approveButtonText = approveButtonText;
        this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, oldValue, approveButtonText);
    }

    @Override
    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        Object[] filterArray = new FileFilter[this.filters.size()];
        this.filters.copyInto(filterArray);
        return filterArray;
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null && !this.filters.contains(filter)) {
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.addElement(filter);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
            if (this.fileFilter == null && this.filters.size() == 1) {
                this.setFileFilter(filter);
            }
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter f) {
        if (this.filters.contains(f)) {
            if (this.getFileFilter() == f) {
                this.setFileFilter(null);
            }
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.removeElement(f);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    @Override
    public void resetChoosableFileFilters() {
        FileFilter[] oldValue = this.getChoosableFileFilters();
        this.setFileFilter(null);
        this.filters.removeAllElements();
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
    }

    @Override
    public FileFilter getAcceptAllFileFilter() {
        FileFilter filter = null;
        if (this.getUI() != null) {
            filter = this.getUI().getAcceptAllFileFilter(this);
        }
        return filter;
    }

    @Override
    public boolean isAcceptAllFileFilterUsed() {
        return this.useAcceptAllFileFilter;
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        boolean oldValue = this.useAcceptAllFileFilter;
        this.useAcceptAllFileFilter = b;
        if (!b) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        } else {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY, oldValue, this.useAcceptAllFileFilter);
    }

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    @Override
    public void setAccessory(JComponent newAccessory) {
        JComponent oldValue = this.accessory;
        this.accessory = newAccessory;
        this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, oldValue, this.accessory);
    }

    @Override
    public void setFileSelectionMode(int mode) {
        if (this.fileSelectionMode == mode) {
            return;
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Incorrect Mode for file selection: " + mode);
        }
        int oldValue = this.fileSelectionMode;
        this.fileSelectionMode = mode;
        this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, oldValue, this.fileSelectionMode);
    }

    @Override
    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    @Override
    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    @Override
    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        if (this.multiSelectionEnabled == b) {
            return;
        }
        boolean oldValue = this.multiSelectionEnabled;
        this.multiSelectionEnabled = b;
        this.firePropertyChange(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY, oldValue, this.multiSelectionEnabled);
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    @Override
    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    @Override
    public void setFileHidingEnabled(boolean b) {
        if (this.showFilesListener != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener(SHOW_HIDDEN_PROP, this.showFilesListener);
            this.showFilesListener = null;
        }
        boolean oldValue = this.useFileHiding;
        this.useFileHiding = b;
        this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, oldValue, this.useFileHiding);
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        FileFilter oldValue = this.fileFilter;
        this.fileFilter = filter;
        if (filter != null) {
            if (this.isMultiSelectionEnabled() && this.selectedFiles != null && this.selectedFiles.length > 0) {
                Vector<File> fList = new Vector<File>();
                boolean failed = false;
                for (File file : this.selectedFiles) {
                    if (filter.accept(file)) {
                        fList.add(file);
                        continue;
                    }
                    failed = true;
                }
                if (failed) {
                    this.setSelectedFiles(fList.size() == 0 ? null : fList.toArray(new File[fList.size()]));
                }
            } else if (this.selectedFile != null && !filter.accept(this.selectedFile)) {
                this.setSelectedFile(null);
            }
        }
        this.firePropertyChange(FILE_FILTER_CHANGED_PROPERTY, oldValue, this.fileFilter);
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public void setFileView(FileView fileView) {
        FileView oldValue = this.fileView;
        this.fileView = fileView;
        this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, oldValue, fileView);
    }

    @Override
    public FileView getFileView() {
        return this.fileView;
    }

    @Override
    public String getName(File f) {
        String filename = null;
        if (f != null) {
            if (this.getFileView() != null) {
                filename = this.getFileView().getName(f);
            }
            FileView uiFileView = this.getUI().getFileView(this);
            if (filename == null && uiFileView != null) {
                filename = uiFileView.getName(f);
            }
        }
        return filename;
    }

    @Override
    public String getDescription(File f) {
        String description = null;
        if (f != null) {
            if (this.getFileView() != null) {
                description = this.getFileView().getDescription(f);
            }
            FileView uiFileView = this.getUI().getFileView(this);
            if (description == null && uiFileView != null) {
                description = uiFileView.getDescription(f);
            }
        }
        return description;
    }

    @Override
    public String getTypeDescription(File f) {
        String typeDescription = null;
        if (f != null) {
            if (this.getFileView() != null) {
                typeDescription = this.getFileView().getTypeDescription(f);
            }
            FileView uiFileView = this.getUI().getFileView(this);
            if (typeDescription == null && uiFileView != null) {
                typeDescription = uiFileView.getTypeDescription(f);
            }
        }
        return typeDescription;
    }

    @Override
    public Icon getIcon(File f) {
        Icon icon = null;
        if (f != null) {
            if (this.getFileView() != null) {
                icon = this.getFileView().getIcon(f);
            }
            FileView uiFileView = this.getUI().getFileView(this);
            if (icon == null && uiFileView != null) {
                icon = uiFileView.getIcon(f);
            }
        }
        return icon;
    }

    @Override
    public boolean isTraversable(File f) {
        Boolean traversable = null;
        if (f != null) {
            if (this.getFileView() != null) {
                traversable = this.getFileView().isTraversable(f);
            }
            FileView uiFileView = this.getUI().getFileView(this);
            if (traversable == null && uiFileView != null) {
                traversable = uiFileView.isTraversable(f);
            }
            if (traversable == null) {
                traversable = this.getFileSystemView().isTraversable(f);
            }
        }
        return traversable != null && traversable != false;
    }

    @Override
    public boolean accept(File f) {
        boolean shown = true;
        if (f != null && this.fileFilter != null) {
            shown = this.fileFilter.accept(f);
        }
        return shown;
    }

    @Override
    public void setFileSystemView(FileSystemView fsv) {
        FileSystemView oldValue = this.fileSystemView;
        this.fileSystemView = fsv;
        this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, oldValue, this.fileSystemView);
    }

    @Override
    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    @Override
    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    @Override
    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    @Override
    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        long mostRecentEventTime = EventQueue.getMostRecentEventTime();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, command, mostRecentEventTime, modifiers);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void updateUI() {
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        FileChooserUI ui = (FileChooserUI)UIManager.getUI(this);
        if (this.fileSystemView == null) {
            this.setFileSystemView(MockFileSystemView.getFileSystemView());
        }
        this.setUI(ui);
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installShowFilesListener();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        FileSystemView fsv = null;
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if (this.fileSystemView.equals(MockFileSystemView.getFileSystemView())) {
            fsv = this.fileSystemView;
            this.fileSystemView = null;
        }
        s.defaultWriteObject();
        if (fsv != null) {
            this.fileSystemView = fsv;
        }
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if (this.getUIClassID().equals(uiClassID)) {
            try {
                Method getWrite = JComponent.class.getMethod("getWriteObjCounter", JComponent.class);
                getWrite.setAccessible(true);
                byte count = (Byte)getWrite.invoke(null, this);
                Method setWrite = JComponent.class.getMethod("setWriteObjCounter", JComponent.class, Byte.TYPE);
                setWrite.setAccessible(true);
                Object[] objectArray = new Object[2];
                objectArray[0] = this;
                count = (byte)(count - 1);
                objectArray[1] = count;
                setWrite.invoke(null, objectArray);
                if (count == 0 && this.ui != null) {
                    this.ui.installUI(this);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Bug in EvoSuite", e);
            }
        }
    }

    @Override
    protected String paramString() {
        String useFileHidingString;
        String dialogTitleString;
        String approveButtonTextString = this.approveButtonText != null ? this.approveButtonText : "";
        String string = dialogTitleString = this.dialogTitle != null ? this.dialogTitle : "";
        String dialogTypeString = this.dialogType == 0 ? "OPEN_DIALOG" : (this.dialogType == 1 ? "SAVE_DIALOG" : (this.dialogType == 2 ? "CUSTOM_DIALOG" : ""));
        String returnValueString = this.returnValue == 1 ? "CANCEL_OPTION" : (this.returnValue == 0 ? "APPROVE_OPTION" : (this.returnValue == -1 ? "ERROR_OPTION" : ""));
        String string2 = useFileHidingString = this.useFileHiding ? "true" : "false";
        String fileSelectionModeString = this.fileSelectionMode == 0 ? "FILES_ONLY" : (this.fileSelectionMode == 1 ? "DIRECTORIES_ONLY" : (this.fileSelectionMode == 2 ? "FILES_AND_DIRECTORIES" : ""));
        String currentDirectoryString = this.currentDirectory != null ? this.currentDirectory.toString() : "";
        String selectedFileString = this.selectedFile != null ? this.selectedFile.toString() : "";
        return super.paramString() + ",MOCK OBJECT" + ",approveButtonText=" + approveButtonTextString + ",currentDirectory=" + currentDirectoryString + ",dialogTitle=" + dialogTitleString + ",dialogType=" + dialogTypeString + ",fileSelectionMode=" + fileSelectionModeString + ",returnValue=" + returnValueString + ",selectedFile=" + selectedFileString + ",useFileHiding=" + useFileHidingString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return super.getAccessibleContext();
    }

    private static class MockWeakPCL
    implements PropertyChangeListener {
        WeakReference<MockJFileChooser> jfcRef;

        public MockWeakPCL(MockJFileChooser jfc) {
            this.jfcRef = new WeakReference<MockJFileChooser>(jfc);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            assert (ev.getPropertyName().equals(MockJFileChooser.SHOW_HIDDEN_PROP));
            MockJFileChooser jfc = (MockJFileChooser)this.jfcRef.get();
            if (jfc == null) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener(MockJFileChooser.SHOW_HIDDEN_PROP, this);
            } else {
                boolean oldValue = jfc.useFileHiding;
                jfc.useFileHiding = (Boolean)ev.getNewValue() == false;
                jfc.firePropertyChange(MockJFileChooser.FILE_HIDING_CHANGED_PROPERTY, oldValue, jfc.useFileHiding);
            }
        }
    }
}

