/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.testdata;

import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFile;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class FileSystemHandling {
    public static boolean appendStringToFile(EvoSuiteFile file, String value) {
        if (file == null || value == null) {
            return false;
        }
        return FileSystemHandling.appendDataToFile(file, value.getBytes());
    }

    public static boolean appendLineToFile(EvoSuiteFile file, String line) {
        if (file == null || line == null) {
            return false;
        }
        return FileSystemHandling.appendStringToFile(file, line + "\n");
    }

    public static boolean appendDataToFile(EvoSuiteFile file, byte[] data) {
        if (file == null || data == null) {
            return false;
        }
        FSObject target = VirtualFileSystem.getInstance().findFSObject(file.getPath());
        if (target != null && (target.isFolder() || !target.isWritePermission())) {
            return false;
        }
        if (target == null) {
            boolean created = VirtualFileSystem.getInstance().createFile(file.getPath());
            if (!created) {
                return false;
            }
            target = VirtualFileSystem.getInstance().findFSObject(file.getPath());
            assert (target != null);
        }
        VFile vf = (VFile)target;
        vf.writeBytes(data, 0, data.length);
        return true;
    }

    public static boolean createFolder(EvoSuiteFile file) {
        if (file == null) {
            return false;
        }
        return VirtualFileSystem.getInstance().createFolder(file.getPath());
    }

    public static boolean setPermissions(EvoSuiteFile file, boolean isReadable, boolean isWritable, boolean isExecutable) {
        if (file == null) {
            return false;
        }
        FSObject target = VirtualFileSystem.getInstance().findFSObject(file.getPath());
        if (target == null) {
            return false;
        }
        target.setExecutePermission(isReadable);
        target.setWritePermission(isWritable);
        target.setExecutePermission(isExecutable);
        return true;
    }

    public static boolean shouldThrowIOException(EvoSuiteFile file) {
        if (file == null) {
            return false;
        }
        return VirtualFileSystem.getInstance().setShouldThrowIOException(file);
    }

    public static boolean shouldAllThrowIOExceptions() {
        return VirtualFileSystem.getInstance().setShouldAllThrowIOExceptions();
    }
}

