/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.action.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.action.internal.CollectionAction;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerGroup;
import org.evosuite.shaded.org.hibernate.event.spi.EventType;
import org.evosuite.shaded.org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection collection, CollectionPersister persister, Serializable id, SessionImplementor session) {
        super(persister, collection, id, session);
    }

    @Override
    public void execute() throws HibernateException {
        PersistentCollection collection = this.getCollection();
        this.preRecreate();
        this.getPersister().recreate(collection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postRecreate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().recreateCollection(this.getPersister().getRole());
        }
    }

    private void preRecreate() {
        EventListenerGroup<PreCollectionRecreateEventListener> listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent event = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPreRecreateCollection(event);
        }
    }

    private void postRecreate() {
        EventListenerGroup<PostCollectionRecreateEventListener> listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent event = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPostRecreateCollection(event);
        }
    }
}

