/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.action.internal;

import org.evosuite.shaded.org.hibernate.OptimisticLockException;
import org.evosuite.shaded.org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;

public class EntityVerifyVersionProcess
implements BeforeTransactionCompletionProcess {
    private final Object object;
    private final EntityEntry entry;

    public EntityVerifyVersionProcess(Object object, EntityEntry entry) {
        this.object = object;
        this.entry = entry;
    }

    @Override
    public void doBeforeTransactionCompletion(SessionImplementor session) {
        EntityPersister persister = this.entry.getPersister();
        if (!this.entry.isExistsInDatabase()) {
            return;
        }
        Object latestVersion = persister.getCurrentVersion(this.entry.getId(), session);
        if (!this.entry.getVersion().equals(latestVersion)) {
            throw new OptimisticLockException(this.object, "Newer version [" + latestVersion + "] of entity [" + MessageHelper.infoString(this.entry.getEntityName(), this.entry.getId()) + "] found in database");
        }
    }
}

