/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.annotations.common.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.evosuite.shaded.org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.evosuite.shaded.org.hibernate.annotations.common.annotationfactory.AnnotationProxy;

public class AnnotationFactory {
    public static <T extends Annotation> T create(AnnotationDescriptor descriptor) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> proxyClass = Proxy.getProxyClass(classLoader, descriptor.type());
        AnnotationProxy handler = new AnnotationProxy(descriptor);
        try {
            return (T)AnnotationFactory.getProxyInstance(proxyClass, handler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Annotation> T getProxyInstance(Class<T> proxyClass, InvocationHandler handler) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = proxyClass.getConstructor(InvocationHandler.class);
        return (T)((Annotation)constructor.newInstance(handler));
    }
}

