/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.instrumentation.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.bytecode.instrumentation.internal.javassist.JavassistHelper;
import org.evosuite.shaded.org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;

public class FieldInterceptionHelper {
    private static final Set<Delegate> INSTRUMENTATION_DELEGATES = FieldInterceptionHelper.buildInstrumentationDelegates();

    private static Set<Delegate> buildInstrumentationDelegates() {
        HashSet<Delegate> delegates = new HashSet<Delegate>();
        delegates.add(JavassistDelegate.INSTANCE);
        return delegates;
    }

    public static boolean isInstrumented(Class entityClass) {
        for (Delegate delegate : INSTRUMENTATION_DELEGATES) {
            if (!delegate.isInstrumented(entityClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstrumented(Object object) {
        return object != null && FieldInterceptionHelper.isInstrumented(object.getClass());
    }

    public static FieldInterceptor extractFieldInterceptor(Object object) {
        Delegate delegate;
        if (object == null) {
            return null;
        }
        FieldInterceptor interceptor = null;
        Iterator<Delegate> i$ = INSTRUMENTATION_DELEGATES.iterator();
        while (i$.hasNext() && (interceptor = (delegate = i$.next()).extractInterceptor(object)) == null) {
        }
        return interceptor;
    }

    public static FieldInterceptor injectFieldInterceptor(Object entity, String entityName, Set uninitializedFieldNames, SessionImplementor session) {
        Delegate delegate;
        if (entity == null) {
            return null;
        }
        FieldInterceptor interceptor = null;
        Iterator<Delegate> i$ = INSTRUMENTATION_DELEGATES.iterator();
        while (i$.hasNext() && (interceptor = (delegate = i$.next()).injectInterceptor(entity, entityName, uninitializedFieldNames, session)) == null) {
        }
        return interceptor;
    }

    private FieldInterceptionHelper() {
    }

    private static class JavassistDelegate
    implements Delegate {
        public static final JavassistDelegate INSTANCE = new JavassistDelegate();
        public static final String MARKER = "org.evosuite.shaded.org.hibernate.bytecode.internal.javassist.FieldHandled";

        private JavassistDelegate() {
        }

        @Override
        public boolean isInstrumented(Class classToCheck) {
            for (Class<?> definedInterface : classToCheck.getInterfaces()) {
                if (!MARKER.equals(definedInterface.getName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public FieldInterceptor extractInterceptor(Object entity) {
            for (Class<?> definedInterface : entity.getClass().getInterfaces()) {
                if (!MARKER.equals(definedInterface.getName())) continue;
                return JavassistHelper.extractFieldInterceptor(entity);
            }
            return null;
        }

        @Override
        public FieldInterceptor injectInterceptor(Object entity, String entityName, Set uninitializedFieldNames, SessionImplementor session) {
            for (Class<?> definedInterface : entity.getClass().getInterfaces()) {
                if (!MARKER.equals(definedInterface.getName())) continue;
                return JavassistHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
            }
            return null;
        }
    }

    private static interface Delegate {
        public boolean isInstrumented(Class var1);

        public FieldInterceptor extractInterceptor(Object var1);

        public FieldInterceptor injectInterceptor(Object var1, String var2, Set var3, SessionImplementor var4);
    }
}

