/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.instrumentation.spi;

import java.io.Serializable;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.LazyInitializationException;
import org.evosuite.shaded.org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.evosuite.shaded.org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractFieldInterceptor
implements FieldInterceptor,
Serializable {
    private transient SessionImplementor session;
    private Set uninitializedFields;
    private final String entityName;
    private transient boolean initializing;
    private boolean dirty;

    protected AbstractFieldInterceptor(SessionImplementor session, Set uninitializedFields, String entityName) {
        this.session = session;
        this.uninitializedFields = uninitializedFields;
        this.entityName = entityName;
    }

    @Override
    public final void setSession(SessionImplementor session) {
        this.session = session;
    }

    @Override
    public final boolean isInitialized() {
        return this.uninitializedFields == null || this.uninitializedFields.size() == 0;
    }

    @Override
    public final boolean isInitialized(String field) {
        return this.uninitializedFields == null || !this.uninitializedFields.contains(field);
    }

    @Override
    public final void dirty() {
        this.dirty = true;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object intercept(Object target, String fieldName, Object value) {
        if (this.initializing) {
            return value;
        }
        if (this.uninitializedFields != null && this.uninitializedFields.contains(fieldName)) {
            Object result;
            if (this.session == null) {
                throw new LazyInitializationException("entity with lazy properties is not associated with a session");
            }
            if (!this.session.isOpen() || !this.session.isConnected()) {
                throw new LazyInitializationException("session is not connected");
            }
            this.initializing = true;
            try {
                result = ((LazyPropertyInitializer)((Object)this.session.getFactory().getEntityPersister(this.entityName))).initializeLazyProperty(fieldName, target, this.session);
            }
            finally {
                this.initializing = false;
            }
            this.uninitializedFields = null;
            return result;
        }
        return value;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final Set getUninitializedFields() {
        return this.uninitializedFields;
    }

    public final String getEntityName() {
        return this.entityName;
    }

    public final boolean isInitializing() {
        return this.initializing;
    }
}

