/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.internal.javassist;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import org.evosuite.shaded.javassist.CannotCompileException;
import org.evosuite.shaded.javassist.ClassPool;
import org.evosuite.shaded.javassist.bytecode.BadBytecode;
import org.evosuite.shaded.javassist.bytecode.Bytecode;
import org.evosuite.shaded.javassist.bytecode.ClassFile;
import org.evosuite.shaded.javassist.bytecode.CodeAttribute;
import org.evosuite.shaded.javassist.bytecode.CodeIterator;
import org.evosuite.shaded.javassist.bytecode.ConstPool;
import org.evosuite.shaded.javassist.bytecode.Descriptor;
import org.evosuite.shaded.javassist.bytecode.FieldInfo;
import org.evosuite.shaded.javassist.bytecode.MethodInfo;
import org.evosuite.shaded.javassist.bytecode.StackMapTable;
import org.evosuite.shaded.javassist.bytecode.stackmap.MapMaker;
import org.evosuite.shaded.org.hibernate.bytecode.internal.javassist.FieldFilter;
import org.evosuite.shaded.org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.evosuite.shaded.org.hibernate.bytecode.internal.javassist.FieldHandler;

public class FieldTransformer {
    private static final String EACH_READ_METHOD_PREFIX = "$javassist_read_";
    private static final String EACH_WRITE_METHOD_PREFIX = "$javassist_write_";
    private static final String FIELD_HANDLED_TYPE_NAME = FieldHandled.class.getName();
    private static final String HANDLER_FIELD_NAME = "$JAVASSIST_READ_WRITE_HANDLER";
    private static final String FIELD_HANDLER_TYPE_NAME = FieldHandler.class.getName();
    private static final String HANDLER_FIELD_DESCRIPTOR = 'L' + FIELD_HANDLER_TYPE_NAME.replace('.', '/') + ';';
    private static final String GETFIELDHANDLER_METHOD_NAME = "getFieldHandler";
    private static final String SETFIELDHANDLER_METHOD_NAME = "setFieldHandler";
    private static final String GETFIELDHANDLER_METHOD_DESCRIPTOR = "()" + HANDLER_FIELD_DESCRIPTOR;
    private static final String SETFIELDHANDLER_METHOD_DESCRIPTOR = "(" + HANDLER_FIELD_DESCRIPTOR + ")V";
    private final FieldFilter filter;
    private final ClassPool classPool;

    FieldTransformer(FieldFilter f, ClassPool c) {
        this.filter = f;
        this.classPool = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(File file) throws Exception {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        ClassFile classfile = new ClassFile(in);
        this.transform(classfile);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        try {
            classfile.write(out);
        }
        finally {
            out.close();
        }
    }

    public void transform(ClassFile classFile) throws Exception {
        if (classFile.isInterface()) {
            return;
        }
        try {
            this.addFieldHandlerField(classFile);
            this.addGetFieldHandlerMethod(classFile);
            this.addSetFieldHandlerMethod(classFile);
            this.addFieldHandledInterface(classFile);
            this.addReadWriteMethods(classFile);
            this.transformInvokevirtualsIntoPutAndGetfields(classFile);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void addFieldHandlerField(ClassFile classfile) throws CannotCompileException {
        ConstPool constPool = classfile.getConstPool();
        FieldInfo fieldInfo = new FieldInfo(constPool, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        fieldInfo.setAccessFlags(130);
        classfile.addField(fieldInfo);
    }

    private void addGetFieldHandlerMethod(ClassFile classfile) throws CannotCompileException, BadBytecode {
        ConstPool constPool = classfile.getConstPool();
        int thisClassInfo = constPool.getThisClassInfo();
        MethodInfo getterMethodInfo = new MethodInfo(constPool, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR);
        Bytecode code = new Bytecode(constPool, 2, 1);
        code.addAload(0);
        code.addOpcode(180);
        int fieldIndex = constPool.addFieldrefInfo(thisClassInfo, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        code.addIndex(fieldIndex);
        code.addOpcode(176);
        getterMethodInfo.setCodeAttribute(code.toCodeAttribute());
        getterMethodInfo.setAccessFlags(1);
        CodeAttribute codeAttribute = getterMethodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable smt = MapMaker.make(this.classPool, getterMethodInfo);
            codeAttribute.setAttribute(smt);
        }
        classfile.addMethod(getterMethodInfo);
    }

    private void addSetFieldHandlerMethod(ClassFile classfile) throws CannotCompileException, BadBytecode {
        ConstPool constPool = classfile.getConstPool();
        int thisClassInfo = constPool.getThisClassInfo();
        MethodInfo methodInfo = new MethodInfo(constPool, SETFIELDHANDLER_METHOD_NAME, SETFIELDHANDLER_METHOD_DESCRIPTOR);
        Bytecode code = new Bytecode(constPool, 3, 3);
        code.addAload(0);
        code.addAload(1);
        code.addOpcode(181);
        int fieldIndex = constPool.addFieldrefInfo(thisClassInfo, HANDLER_FIELD_NAME, HANDLER_FIELD_DESCRIPTOR);
        code.addIndex(fieldIndex);
        code.addOpcode(177);
        methodInfo.setCodeAttribute(code.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable smt = MapMaker.make(this.classPool, methodInfo);
            codeAttribute.setAttribute(smt);
        }
        classfile.addMethod(methodInfo);
    }

    private void addFieldHandledInterface(ClassFile classfile) {
        String[] interfaceNames = classfile.getInterfaces();
        String[] newInterfaceNames = new String[interfaceNames.length + 1];
        System.arraycopy(interfaceNames, 0, newInterfaceNames, 0, interfaceNames.length);
        newInterfaceNames[newInterfaceNames.length - 1] = FIELD_HANDLED_TYPE_NAME;
        classfile.setInterfaces(newInterfaceNames);
    }

    private void addReadWriteMethods(ClassFile classfile) throws CannotCompileException, BadBytecode {
        List fields = classfile.getFields();
        for (Object field : fields) {
            FieldInfo finfo = (FieldInfo)field;
            if ((finfo.getAccessFlags() & 8) != 0 || finfo.getName().equals(HANDLER_FIELD_NAME)) continue;
            if (this.filter.handleRead(finfo.getDescriptor(), finfo.getName())) {
                this.addReadMethod(classfile, finfo);
            }
            if (!this.filter.handleWrite(finfo.getDescriptor(), finfo.getName())) continue;
            this.addWriteMethod(classfile, finfo);
        }
    }

    private void addReadMethod(ClassFile classfile, FieldInfo finfo) throws CannotCompileException, BadBytecode {
        ConstPool constPool = classfile.getConstPool();
        int thisClassInfo = constPool.getThisClassInfo();
        String readMethodDescriptor = "()" + finfo.getDescriptor();
        MethodInfo readMethodInfo = new MethodInfo(constPool, EACH_READ_METHOD_PREFIX + finfo.getName(), readMethodDescriptor);
        Bytecode code = new Bytecode(constPool, 5, 3);
        code.addAload(0);
        code.addOpcode(180);
        int baseFieldIndex = constPool.addFieldrefInfo(thisClassInfo, finfo.getName(), finfo.getDescriptor());
        code.addIndex(baseFieldIndex);
        code.addAload(0);
        int enabledClassIndex = constPool.addClassInfo(FIELD_HANDLED_TYPE_NAME);
        code.addInvokeinterface(enabledClassIndex, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        code.addOpcode(199);
        code.addIndex(4);
        FieldTransformer.addTypeDependDataReturn(code, finfo.getDescriptor());
        FieldTransformer.addTypeDependDataStore(code, finfo.getDescriptor(), 1);
        code.addAload(0);
        code.addInvokeinterface(enabledClassIndex, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        code.addAload(0);
        code.addLdc(finfo.getName());
        FieldTransformer.addTypeDependDataLoad(code, finfo.getDescriptor(), 1);
        FieldTransformer.addInvokeFieldHandlerMethod(classfile, code, finfo.getDescriptor(), true);
        FieldTransformer.addTypeDependDataReturn(code, finfo.getDescriptor());
        readMethodInfo.setCodeAttribute(code.toCodeAttribute());
        readMethodInfo.setAccessFlags(1);
        CodeAttribute codeAttribute = readMethodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable smt = MapMaker.make(this.classPool, readMethodInfo);
            codeAttribute.setAttribute(smt);
        }
        classfile.addMethod(readMethodInfo);
    }

    private void addWriteMethod(ClassFile classfile, FieldInfo finfo) throws CannotCompileException, BadBytecode {
        ConstPool constPool = classfile.getConstPool();
        int thisClassInfo = constPool.getThisClassInfo();
        String writeMethodDescriptor = "(" + finfo.getDescriptor() + ")V";
        MethodInfo writeMethodInfo = new MethodInfo(constPool, EACH_WRITE_METHOD_PREFIX + finfo.getName(), writeMethodDescriptor);
        Bytecode code = new Bytecode(constPool, 6, 3);
        code.addAload(0);
        int enabledClassIndex = constPool.addClassInfo(FIELD_HANDLED_TYPE_NAME);
        code.addInvokeinterface(enabledClassIndex, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        code.addOpcode(199);
        code.addIndex(9);
        code.addAload(0);
        FieldTransformer.addTypeDependDataLoad(code, finfo.getDescriptor(), 1);
        code.addOpcode(181);
        int baseFieldIndex = constPool.addFieldrefInfo(thisClassInfo, finfo.getName(), finfo.getDescriptor());
        code.addIndex(baseFieldIndex);
        code.growStack(-Descriptor.dataSize(finfo.getDescriptor()));
        code.addOpcode(177);
        code.addAload(0);
        code.addOpcode(89);
        code.addInvokeinterface(enabledClassIndex, GETFIELDHANDLER_METHOD_NAME, GETFIELDHANDLER_METHOD_DESCRIPTOR, 1);
        code.addAload(0);
        code.addLdc(finfo.getName());
        code.addAload(0);
        code.addOpcode(180);
        code.addIndex(baseFieldIndex);
        code.growStack(Descriptor.dataSize(finfo.getDescriptor()) - 1);
        FieldTransformer.addTypeDependDataLoad(code, finfo.getDescriptor(), 1);
        FieldTransformer.addInvokeFieldHandlerMethod(classfile, code, finfo.getDescriptor(), false);
        code.addOpcode(181);
        code.addIndex(baseFieldIndex);
        code.growStack(-Descriptor.dataSize(finfo.getDescriptor()));
        code.addOpcode(177);
        writeMethodInfo.setCodeAttribute(code.toCodeAttribute());
        writeMethodInfo.setAccessFlags(1);
        CodeAttribute codeAttribute = writeMethodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable smt = MapMaker.make(this.classPool, writeMethodInfo);
            codeAttribute.setAttribute(smt);
        }
        classfile.addMethod(writeMethodInfo);
    }

    private void transformInvokevirtualsIntoPutAndGetfields(ClassFile classfile) throws CannotCompileException, BadBytecode {
        for (Object o : classfile.getMethods()) {
            CodeAttribute codeAttr;
            MethodInfo methodInfo = (MethodInfo)o;
            String methodName = methodInfo.getName();
            if (methodName.startsWith(EACH_READ_METHOD_PREFIX) || methodName.startsWith(EACH_WRITE_METHOD_PREFIX) || methodName.equals(GETFIELDHANDLER_METHOD_NAME) || methodName.equals(SETFIELDHANDLER_METHOD_NAME) || (codeAttr = methodInfo.getCodeAttribute()) == null) continue;
            CodeIterator iter = codeAttr.iterator();
            while (iter.hasNext()) {
                int pos = iter.next();
                pos = this.transformInvokevirtualsIntoGetfields(classfile, iter, pos);
                this.transformInvokevirtualsIntoPutfields(classfile, iter, pos);
            }
            StackMapTable smt = MapMaker.make(this.classPool, methodInfo);
            codeAttr.setAttribute(smt);
        }
    }

    private int transformInvokevirtualsIntoGetfields(ClassFile classfile, CodeIterator iter, int pos) {
        ConstPool constPool = classfile.getConstPool();
        int c = iter.byteAt(pos);
        if (c != 180) {
            return pos;
        }
        int index = iter.u16bitAt(pos + 1);
        String fieldName = constPool.getFieldrefName(index);
        String className = constPool.getFieldrefClassName(index);
        if (!this.filter.handleReadAccess(className, fieldName)) {
            return pos;
        }
        String fieldReaderMethodDescriptor = "()" + constPool.getFieldrefType(index);
        int fieldReaderMethodIndex = constPool.addMethodrefInfo(constPool.getThisClassInfo(), EACH_READ_METHOD_PREFIX + fieldName, fieldReaderMethodDescriptor);
        iter.writeByte(182, pos);
        iter.write16bit(fieldReaderMethodIndex, pos + 1);
        return pos;
    }

    private int transformInvokevirtualsIntoPutfields(ClassFile classfile, CodeIterator iter, int pos) {
        ConstPool constPool = classfile.getConstPool();
        int c = iter.byteAt(pos);
        if (c != 181) {
            return pos;
        }
        int index = iter.u16bitAt(pos + 1);
        String fieldName = constPool.getFieldrefName(index);
        String className = constPool.getFieldrefClassName(index);
        if (!this.filter.handleWriteAccess(className, fieldName)) {
            return pos;
        }
        String fieldWriterMethodDescriptor = "(" + constPool.getFieldrefType(index) + ")V";
        int fieldWriterMethodIndex = constPool.addMethodrefInfo(constPool.getThisClassInfo(), EACH_WRITE_METHOD_PREFIX + fieldName, fieldWriterMethodDescriptor);
        iter.writeByte(182, pos);
        iter.write16bit(fieldWriterMethodIndex, pos + 1);
        return pos;
    }

    private static void addInvokeFieldHandlerMethod(ClassFile classfile, Bytecode code, String typeName, boolean isReadMethod) {
        ConstPool constPool = classfile.getConstPool();
        int callbackTypeIndex = constPool.addClassInfo(FIELD_HANDLER_TYPE_NAME);
        if (typeName.charAt(0) == 'L' && typeName.charAt(typeName.length() - 1) == ';' || typeName.charAt(0) == '[') {
            String type;
            int indexOfL = typeName.indexOf(76);
            if (indexOfL == 0) {
                type = typeName.substring(1, typeName.length() - 1);
                type = type.replace('/', '.');
            } else {
                type = indexOfL == -1 ? typeName : typeName.replace('/', '.');
            }
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readObject", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", 4);
                code.addCheckcast(type);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeObject", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", 5);
                code.addCheckcast(type);
            }
        } else if (typeName.equals("Z")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readBoolean", "(Ljava/lang/Object;Ljava/lang/String;Z)Z", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeBoolean", "(Ljava/lang/Object;Ljava/lang/String;ZZ)Z", 5);
            }
        } else if (typeName.equals("B")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readByte", "(Ljava/lang/Object;Ljava/lang/String;B)B", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeByte", "(Ljava/lang/Object;Ljava/lang/String;BB)B", 5);
            }
        } else if (typeName.equals("C")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readChar", "(Ljava/lang/Object;Ljava/lang/String;C)C", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeChar", "(Ljava/lang/Object;Ljava/lang/String;CC)C", 5);
            }
        } else if (typeName.equals("I")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readInt", "(Ljava/lang/Object;Ljava/lang/String;I)I", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeInt", "(Ljava/lang/Object;Ljava/lang/String;II)I", 5);
            }
        } else if (typeName.equals("S")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readShort", "(Ljava/lang/Object;Ljava/lang/String;S)S", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeShort", "(Ljava/lang/Object;Ljava/lang/String;SS)S", 5);
            }
        } else if (typeName.equals("D")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readDouble", "(Ljava/lang/Object;Ljava/lang/String;D)D", 5);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeDouble", "(Ljava/lang/Object;Ljava/lang/String;DD)D", 7);
            }
        } else if (typeName.equals("F")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readFloat", "(Ljava/lang/Object;Ljava/lang/String;F)F", 4);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeFloat", "(Ljava/lang/Object;Ljava/lang/String;FF)F", 5);
            }
        } else if (typeName.equals("J")) {
            if (isReadMethod) {
                code.addInvokeinterface(callbackTypeIndex, "readLong", "(Ljava/lang/Object;Ljava/lang/String;J)J", 5);
            } else {
                code.addInvokeinterface(callbackTypeIndex, "writeLong", "(Ljava/lang/Object;Ljava/lang/String;JJ)J", 7);
            }
        } else {
            throw new RuntimeException("bad type: " + typeName);
        }
    }

    private static void addTypeDependDataLoad(Bytecode code, String typeName, int i) {
        if (typeName.charAt(0) == 'L' && typeName.charAt(typeName.length() - 1) == ';' || typeName.charAt(0) == '[') {
            code.addAload(i);
        } else if (typeName.equals("Z") || typeName.equals("B") || typeName.equals("C") || typeName.equals("I") || typeName.equals("S")) {
            code.addIload(i);
        } else if (typeName.equals("D")) {
            code.addDload(i);
        } else if (typeName.equals("F")) {
            code.addFload(i);
        } else if (typeName.equals("J")) {
            code.addLload(i);
        } else {
            throw new RuntimeException("bad type: " + typeName);
        }
    }

    private static void addTypeDependDataStore(Bytecode code, String typeName, int i) {
        if (typeName.charAt(0) == 'L' && typeName.charAt(typeName.length() - 1) == ';' || typeName.charAt(0) == '[') {
            code.addAstore(i);
        } else if (typeName.equals("Z") || typeName.equals("B") || typeName.equals("C") || typeName.equals("I") || typeName.equals("S")) {
            code.addIstore(i);
        } else if (typeName.equals("D")) {
            code.addDstore(i);
        } else if (typeName.equals("F")) {
            code.addFstore(i);
        } else if (typeName.equals("J")) {
            code.addLstore(i);
        } else {
            throw new RuntimeException("bad type: " + typeName);
        }
    }

    private static void addTypeDependDataReturn(Bytecode code, String typeName) {
        if (typeName.charAt(0) == 'L' && typeName.charAt(typeName.length() - 1) == ';' || typeName.charAt(0) == '[') {
            code.addOpcode(176);
        } else if (typeName.equals("Z") || typeName.equals("B") || typeName.equals("C") || typeName.equals("I") || typeName.equals("S")) {
            code.addOpcode(172);
        } else if (typeName.equals("D")) {
            code.addOpcode(175);
        } else if (typeName.equals("F")) {
            code.addOpcode(174);
        } else if (typeName.equals("J")) {
            code.addOpcode(173);
        } else {
            throw new RuntimeException("bad type: " + typeName);
        }
    }
}

